package freenetmessageboard.gui;

import java.awt.*;
import javax.swing.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class MessageVerificationFrame extends JFrame {
  BorderLayout mainBorderLayout = new BorderLayout();
  JTabbedPane verificationPanelsTabbedPane = new JTabbedPane();

  java.util.HashMap displayMessageVerificationPanels = new java.util.HashMap();

  public MessageVerificationFrame() {
    try {
      jbInit();
      this.setSize(750,550);
      this.setLocation(10,10);
      this.setTitle("message verification window");
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public void showVerificationRating(freenetmessageboard.core.Message msg, String rating) {
    MessageVerificationPanel panel = (MessageVerificationPanel)this.displayMessageVerificationPanels.get(msg.getUniqueId());
    int index = this.verificationPanelsTabbedPane.indexOfComponent(panel);
    if (index!=-1) {
      this.verificationPanelsTabbedPane.setIconAt(index, ColorsAndIcons.getIconForRating(rating));
    }
  }

  void removeMessage(freenetmessageboard.core.Message msg) {
    MessageVerificationPanel panel = (MessageVerificationPanel)this.displayMessageVerificationPanels.get(msg.getUniqueId());
    this.verificationPanelsTabbedPane.remove(panel);
  }

  public void verifyMessage(freenetmessageboard.core.Message existingMsg, freenetmessageboard.core.Message newMsg) {
    if (this.displayMessageVerificationPanels.containsKey(existingMsg.getUniqueId())==false) {
      MessageVerificationPanel panel = new MessageVerificationPanel(existingMsg, newMsg);
      this.displayMessageVerificationPanels.put(existingMsg.getUniqueId(), panel);
      this.verificationPanelsTabbedPane.add(existingMsg.toShortString(), panel);
      this.verificationPanelsTabbedPane.setIconAt(this.verificationPanelsTabbedPane.getComponentCount()-1, ColorsAndIcons.getIconForRating("NOTYET"));
      this.verificationPanelsTabbedPane.setSelectedComponent(panel);
    }
  }

  public void verifyMessage(freenetmessageboard.core.Message existingMsg) {
    if (this.displayMessageVerificationPanels.containsKey(existingMsg.getUniqueId())==false) {
      MessageVerificationPanel panel = new MessageVerificationPanel(existingMsg);
      this.displayMessageVerificationPanels.put(existingMsg.getUniqueId(), panel);
      this.verificationPanelsTabbedPane.add(existingMsg.toShortString(), panel);
      this.verificationPanelsTabbedPane.setIconAt(this.verificationPanelsTabbedPane.getComponentCount()-1, ColorsAndIcons.getIconForRating("NOTYET"));
      this.verificationPanelsTabbedPane.setSelectedComponent(panel);
    }
  }

  private void jbInit() throws Exception {
    this.getContentPane().setLayout(mainBorderLayout);
    this.getContentPane().add(verificationPanelsTabbedPane, BorderLayout.CENTER);
  }
}