package freenetmessageboard.gui;

import java.awt.*;
import javax.swing.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class MessagePanel extends JPanel {
  BorderLayout mainBorderLayout = new BorderLayout();
  JPanel topPanel = new JPanel();
  JPanel mainPanel = new JPanel();
  JPanel bottomPanel = new JPanel();
  BorderLayout mainPanelBorderLayout = new BorderLayout();
  JPanel headerPanel = new JPanel();
  JPanel fieldsPanel = new JPanel();
  JPanel headerCaptionsPanel = new JPanel();
  BorderLayout headerPanelBorderLayout = new BorderLayout();
  JPanel headerValuesPanel = new JPanel();
  GridLayout headerCaptionsPanelGridLayout = new GridLayout();
  GridLayout headerValuesPanelGridLayout = new GridLayout();
  JLabel sourceLabel = new JLabel();
  JLabel uniqueIdLabel = new JLabel();
  JLabel originalUriLabel = new JLabel();
  JLabel dateLabel = new JLabel();
  JLabel messageTypeLabel = new JLabel();
  JLabel versionLabel = new JLabel();
  JTextField sourceTextField = new JTextField();
  JTextField uniqueIdTextField = new JTextField();
  JTextField originalUriTextField = new JTextField();
  JTextField typeTextField = new JTextField();
  JTextField versionTextField = new JTextField();
  JTextField dateTextField = new JTextField();
  BorderLayout fieldsPanelBorderLayout = new BorderLayout();
  JPanel fieldNamesPanel = new JPanel();
  JPanel fieldValuesPanel = new JPanel();
  GridLayout fieldNamesPanelGridLayout = new GridLayout();
  GridLayout fieldValuesPanelGridLayout = new GridLayout();

  public MessagePanel(freenetmessageboard.core.Message msg) {
    this();
    this.typeTextField.setText(msg.getMessageType());
    this.originalUriTextField.setText(msg.getOriginalUri());
    this.sourceTextField.setText(msg.getSourceUri());
    this.dateTextField.setText(msg.getDate());
    this.uniqueIdTextField.setText(msg.getUniqueId());
    this.versionTextField.setText(msg.getVersion());
    java.util.Map fields = msg.getFields();
    this.fieldNamesPanelGridLayout.setRows(fields.keySet().size());
    this.fieldValuesPanelGridLayout.setRows(fields.keySet().size());
    java.util.Iterator it = fields.keySet().iterator();
    while (it.hasNext()) {
      String fieldName = (String)it.next();
      String fieldValue = (String)fields.get(fieldName);
      JLabel label = new JLabel(fieldName);
      JTextField textField = new JTextField(fieldValue);
      textField.setEditable(false);
      this.fieldNamesPanel.add(label, null);
      this.fieldValuesPanel.add(textField, null);
    }
    this.validate();
  }

  public MessagePanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  private void jbInit() throws Exception {
    this.setLayout(mainBorderLayout);
    mainPanel.setLayout(mainPanelBorderLayout);
    headerPanel.setLayout(headerPanelBorderLayout);
    headerCaptionsPanel.setLayout(headerCaptionsPanelGridLayout);
    headerValuesPanel.setLayout(headerValuesPanelGridLayout);
    headerCaptionsPanelGridLayout.setRows(6);
    headerValuesPanelGridLayout.setRows(6);
    sourceLabel.setText("source:");
    uniqueIdLabel.setText("unique id:");
    originalUriLabel.setText("original uri:");
    dateLabel.setText("date:");
    messageTypeLabel.setText("type:");
    versionLabel.setText("version:");
    sourceTextField.setEditable(false);
    uniqueIdTextField.setEditable(false);
    originalUriTextField.setEditable(false);
    typeTextField.setEditable(false);
    versionTextField.setEditable(false);
    dateTextField.setEditable(false);
    fieldsPanel.setLayout(fieldsPanelBorderLayout);
    fieldNamesPanel.setLayout(fieldNamesPanelGridLayout);
    fieldValuesPanel.setLayout(fieldValuesPanelGridLayout);
    this.add(topPanel, BorderLayout.NORTH);
    this.add(mainPanel,  BorderLayout.CENTER);
    this.add(bottomPanel,  BorderLayout.SOUTH);
    mainPanel.add(headerPanel, BorderLayout.NORTH);
    mainPanel.add(fieldsPanel,  BorderLayout.CENTER);
    headerPanel.add(headerCaptionsPanel,  BorderLayout.WEST);
    headerPanel.add(headerValuesPanel,  BorderLayout.CENTER);
    headerCaptionsPanel.add(sourceLabel, null);
    headerCaptionsPanel.add(uniqueIdLabel, null);
    headerCaptionsPanel.add(originalUriLabel, null);
    headerCaptionsPanel.add(messageTypeLabel, null);
    headerCaptionsPanel.add(versionLabel, null);
    headerCaptionsPanel.add(dateLabel, null);
    headerValuesPanel.add(sourceTextField, null);
    headerValuesPanel.add(uniqueIdTextField, null);
    headerValuesPanel.add(originalUriTextField, null);
    headerValuesPanel.add(typeTextField, null);
    headerValuesPanel.add(versionTextField, null);
    headerValuesPanel.add(dateTextField, null);
    fieldsPanel.add(fieldNamesPanel,  BorderLayout.WEST);
    fieldsPanel.add(fieldValuesPanel, BorderLayout.CENTER);
  }
}