package freenetmessageboard.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;


/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class FakedMessagePanel extends JPanel implements freenetmessageboard.fcpinterface.FCPRequestCallback {
  BorderLayout mainBorderLayout = new BorderLayout();
  JPanel topPanel = new JPanel();
  JLabel jLabel1 = new JLabel();
  JTabbedPane jTabbedPane1 = new JTabbedPane();
  JButton requestOriginalButton = new JButton();
  private freenetmessageboard.core.Message existingMsg;
  private freenetmessageboard.core.Message newMsg;
  private freenetmessageboard.core.Message originalMsg;

  public FakedMessagePanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public FakedMessagePanel(freenetmessageboard.core.Message existingMsg, freenetmessageboard.core.Message newMsg) {
    this();
    this.existingMsg=existingMsg;
    this.newMsg=newMsg;
    MessagePanel msgPanel1 = new MessagePanel(existingMsg);
    MessagePanel msgPanel2 = new MessagePanel(newMsg);
    String nick1 = freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(existingMsg.getSourceKey());
    String nick2 = freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(newMsg.getSourceKey());
    String source1;
    String source2;
    if (existingMsg.getOriginalUri().equals(existingMsg.getSourceUri())) {
      source1 = "existing original from "+nick1;
    } else {
      if (existingMsg.getSourceKey().equals(existingMsg.getOriginalPublicKey())) {
        source1 = "existing signed copy from "+nick1;
      } else {
        source1 = "existing copy from "+nick1;
      }
    }
    if (newMsg.getOriginalUri().equals(newMsg.getSourceUri())) {
      source2 = "new original from "+nick2;
    } else {
      if (newMsg.getSourceKey().equals(newMsg.getOriginalPublicKey())) {
        source2 = "new signed copy from "+nick2;
      } else {
        source2 = "new copy from "+nick2;
      }
    }
    this.jTabbedPane1.add(source1, msgPanel1);
    this.jTabbedPane1.add(source2, msgPanel2);
    this.requestOriginalButton.setText("request original version from "+existingMsg.getOriginalUri());
    this.validate();
    this.repaint();
  }
/*
  public FakedMessagePanel(freenetmessageboard.core.Message msg1, freenetmessageboard.core.Message msg2) {
    this();
    String msg1String = msg1.getString();
    String msg2String = msg2.getString();
    this.topMessageTextPane.setText(msg1.getString());
//    this.bottomMessageTextPane.setText(msg2.getString());
    StringBuffer diffs = new StringBuffer();
    int diffStart=-1;
    int diffEnd=-1;
    for (int i=0; i<msg1String.length(); i++) {
      if (msg2String.length()<=i) {
        diffStart=i;
        diffEnd=msg1String.length()-1;
        break;
      }
      if (msg1String.charAt(i)!=msg2String.charAt(i)) {
        if (diffStart==-1) diffStart=i;
        diffEnd=i;
        continue;
      }
      if (diffStart!=-1 && diffEnd!=-1) {
        diffs.append("there is a difference between the chars "+diffStart+" and "+diffEnd+": \n");
        diffs.append(msg1String.substring(diffStart, diffEnd+1));
        diffs.append(" : ");
        for (int j=diffStart; j<=diffEnd; j++) {
          diffs.append('[');
          diffs.append((int)msg1String.charAt(j));
          diffs.append(']');
        }
        diffs.append('\n');

        diffs.append(msg2String.substring(diffStart, diffEnd+1));
        diffs.append(" : ");
        for (int j=diffStart; j<=diffEnd; j++) {
          if (j>=msg2String.length()) break;
          diffs.append('[');
          diffs.append((int)msg2String.charAt(j));
          diffs.append(']');
        }
        diffs.append("\n\n");
        diffStart=-1;
        diffEnd=-1;
      }
    }
    this.bottomMessageTextPane.setText(diffs.toString());
  }*/

  public void requestSuccesfull(String uri, freenetmessageboard.fcpinterface.RequestedData data) {
    freenetmessageboard.core.Message[] msgs = freenetmessageboard.core.Message.parseMultipleMessageString(freenetmessageboard.core.Message.getStringFromBytes(data.getDataBytes()));
    if (msgs.length==0) {
      this.requestOriginalButton.setText("there were invalid messages found at "+uri+"!");
      return;
    }
    this.requestOriginalButton.setText("requesting of"+this.existingMsg.getOriginalUri()+" was succesful.");
    for (int i=0; i<msgs.length; i++) {
      if (msgs[i].getUniqueId().equals(this.newMsg.getUniqueId())) {
        this.requestOriginalButton.setText("the original version was found!");
        msgs[i].setSource(uri);
        String nick = freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(msgs[i].getOriginalPublicKey());
        MessagePanel origPanel = new MessagePanel(msgs[i]);
        this.jTabbedPane1.add("original version from "+nick, origPanel);
        this.jTabbedPane1.repaint();
        freenetmessageboard.core.MessagePool.instance().replaceMessage(msgs[i], uri);
        return;
      }
    }
    this.requestOriginalButton.setText("there were messages found on "+uri+" but not this one!");
  }

  public void requestFailedWithRouteNotFound(String uri) {
    this.requestOriginalButton.setText("request failed with route not found, retrying...");
    this.requestOriginalVersion();

  }
  public void requestFailedWithDataNotFound(String uri) {
    this.requestOriginalButton.setText("request failed with data not found, click this to retry again");
    this.requestOriginalButton.setEnabled(true);
  }
  public void requestFailedBadly(String uri, String info) {
    if (info.length()>30) { info=info.substring(0,30)+"..."; }
    this.requestOriginalButton.setText("request failed: "+info+", click to try again");
    this.requestOriginalButton.setEnabled(true);
  }
  public void requestStarted(String uri) {
    this.requestOriginalButton.setText("request of "+this.newMsg.getOriginalUri()+"is queued...");
  }

  private void jbInit() throws Exception {
    this.setLayout(mainBorderLayout);
    jLabel1.setForeground(Color.red);
    jLabel1.setText("these two messages are not equal. please check if one of them is " +
    "faked:");
    requestOriginalButton.setFont(new java.awt.Font("Dialog", 0, 10));
    requestOriginalButton.setText("request original version");
    requestOriginalButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        requestOriginalButton_actionPerformed(e);
      }
    });
    this.add(topPanel, BorderLayout.NORTH);
    topPanel.add(jLabel1, null);
    this.add(jTabbedPane1,  BorderLayout.CENTER);
    this.add(requestOriginalButton,  BorderLayout.SOUTH);
  }

  private void requestOriginalVersion() {
    freenetmessageboard.fcpinterface.FCPFacade.instance().startFreenetRequest(this, this.newMsg.getOriginalUri(), 50, false);
    this.requestOriginalButton.setEnabled(false);
  }

  void requestOriginalButton_actionPerformed(ActionEvent e) {
    this.requestOriginalButton.setText("requesting from "+this.newMsg.getOriginalUri());
    this.requestOriginalVersion();
  }
}