package freenetmessageboard.gui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class FMBMainFrame extends JFrame {
  BorderLayout mainFrameBorderLayout = new BorderLayout();
  ContactListPanel contactListPanel = new ContactListPanel();
  JSplitPane jSplitPane1 = new JSplitPane();
  BoardContentPanel boardContentPanel = new BoardContentPanel();
  BorderLayout mainPanelBorderLayout = new BorderLayout();
  JPanel mainPanel = new JPanel();

  public FMBMainFrame() {

    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    super.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
  }

  private void jbInit() throws Exception {
    this.setTitle("freenet message board (alpha4a)");
    this.addWindowListener(new WindowListener() {
      public void windowClosing(WindowEvent e) {
        this_windowClosing(e);
      }

      public void windowClosed(WindowEvent e) {
      }

      public void windowOpened(WindowEvent e) {
      }

      public void windowIconified(WindowEvent e) {
      }

      public void windowDeiconified(WindowEvent e) {
      }

      public void windowActivated(WindowEvent e) {
      }

      public void windowDeactivated(WindowEvent e) {
      }
    });
    this.getContentPane().setLayout(mainFrameBorderLayout);
    mainPanel.setLayout(mainPanelBorderLayout);
    jSplitPane1.setOrientation(JSplitPane.VERTICAL_SPLIT);
    jSplitPane1.setDividerSize(7);
    mainPanel.setMinimumSize(new Dimension(200, 200));
    mainPanel.setPreferredSize(new Dimension(200, 200));
    boardContentPanel.setMinimumSize(new Dimension(155, 150));
    this.getContentPane().add(contactListPanel, BorderLayout.EAST);
    this.getContentPane().add(jSplitPane1,  BorderLayout.CENTER);
    jSplitPane1.add(boardContentPanel, JSplitPane.LEFT);
    jSplitPane1.add(mainPanel, JSplitPane.RIGHT);
    jSplitPane1.setDividerLocation(180);
  }

  void this_windowClosing(WindowEvent e) {
    if (freenetmessageboard.core.MessageGateway.instance().areThereActiveInserts() || freenetmessageboard.core.MessageArchiveTransmitter.instance().areThereActiveInserts()) {
      boolean reallyExit = freenetmessageboard.gui.BetaGUI.instance().showConfirmDialog("if you close fmb now, you're inserts won't be available to anyone.\n do you really want to exit?","there are active inserts left!");
      if (reallyExit==false) {
        return;
      }
    }
    freenetmessageboard.Main.shutDown();
  }
}