package freenetmessageboard.gui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

import freenetmessageboard.core.CoreLogger;
import javax.swing.border.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class ContactPanel extends JPanel {
  BorderLayout contactPanelBorderLayout = new BorderLayout();
  JLabel publicKeyPanel = new JLabel();

  private freenetmessageboard.core.UserMessage lastUserMessage;

  private freenetmessageboard.core.ContactInformation contactInformation;
  JLabel slotInfoLabel = new JLabel();
  JPopupMenu contactPanelPopupMenu = new JPopupMenu();
  JMenuItem showInfoMenuItem = new JMenuItem();
  JMenuItem stopListeningMenuItem = new JMenuItem();
  JMenuItem startListeningMenuItem = new JMenuItem();
  JPanel jPanel1 = new JPanel();
  BorderLayout borderLayout1 = new BorderLayout();
  JLabel nickNamePanel = new JLabel();
  JLabel lastOnlineLabel = new JLabel();
  Border border1;
  JPopupMenu sendingChannelPopupMenu = new JPopupMenu();
  JMenuItem sendBufferdInsertsMenuitem = new JMenuItem();
  JMenuItem showInfoMenuItem1 = new JMenuItem();
  RatingPanel ratingPanel1 = new RatingPanel(new int[] {0,0,0}, new Color[] {ColorsAndIcons.getColorOfRating("GOOD"), ColorsAndIcons.getColorOfRating("NEUTRAL"), ColorsAndIcons.getColorOfRating("EVIL"), this.getBackground() });

  public ContactPanel(freenetmessageboard.core.ContactInformation contactInformation) {
    this();
    this.contactInformation=contactInformation;
    this.updateInformation();
  }

  public void updateInformation() {
    this.nickNamePanel.setText(this.contactInformation.getNickname());

    String channelBaseName = freenetmessageboard.core.MessageGateway.constructPersonalChannelBaseName(this.contactInformation.getPublicKey(), freenetmessageboard.core.MessageGateway.getCurrentDate());
    CoreLogger.log("getting status string from channel "+channelBaseName+"...", CoreLogger.LOG_INFO);
    freenetmessageboard.core.ChannelInfo channelInfo =  freenetmessageboard.core.ChannelInfo.getInstance(channelBaseName);

    this.ratingPanel1.update(this.contactInformation.getRatings());

    if (this.contactInformation.getPublicKey().equals(freenetmessageboard.core.PersonalInfo.instance().getPublicKey())) {
      this.slotInfoLabel.setText(freenetmessageboard.core.MessageGateway.instance().getSlotInfoStringForMyPersonalChannel());
      int activeInsertCount=freenetmessageboard.core.MessageGateway.instance().getActiveInsertCount();
      if (activeInsertCount==0) {
        this.publicKeyPanel.setText("no active inserts, "+freenetmessageboard.core.MessageGateway.instance().getSendBufferSize()+" bytes buffered");
      } else {
        this.publicKeyPanel.setText(activeInsertCount+" active inserts, "+freenetmessageboard.core.MessageGateway.instance().getSendBufferSize()+" bytes buffered");
      }
      return;
    }
    freenetmessageboard.core.Message lastMessage = freenetmessageboard.core.MessagePool.instance().getLatestMessageFromUser(this.contactInformation.getPublicKey());
    String timeString = "no msgs";
    try {
      long lastTime = this.contactInformation.getTimeOfLastActivity();
      long timeDiff = new java.util.Date().getTime()-lastTime;
      long seconds = timeDiff/1000;
      if (seconds<60) {
        timeString = seconds+"s";
      }
      if (seconds>=60 && seconds<=3600) {
        timeString = (seconds/60)+"m";
      }
      if (seconds>3600) {
        timeString = (seconds/3600)+"h";
      }
      if (lastMessage.isFromCurrentDay()) {
        this.lastOnlineLabel.setForeground(this.nickNamePanel.getForeground());
      } else {
        this.lastOnlineLabel.setForeground(Color.red);
      }
    } catch (Throwable t) {
      CoreLogger.log("error while caluclating time offset: "+t.getClass().getName()+": "+t.getMessage(), CoreLogger.LOG_ERROR);
    }

    this.lastOnlineLabel.setText(timeString);
    this.publicKeyPanel.setText(channelInfo.getStatusString());
    this.slotInfoLabel.setText(channelInfo.getSlotInfoString());
  }

  public ContactPanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  private void jbInit() throws Exception {
    border1 = BorderFactory.createEtchedBorder(Color.white,new Color(148, 145, 140));
    this.setLayout(contactPanelBorderLayout);
    publicKeyPanel.setFont(new java.awt.Font("Dialog", 0, 9));
    publicKeyPanel.setForeground(Color.black);
    publicKeyPanel.setMinimumSize(new Dimension(117, 11));
    publicKeyPanel.setPreferredSize(new Dimension(117, 11));
    publicKeyPanel.setHorizontalAlignment(SwingConstants.LEFT);
    publicKeyPanel.setHorizontalTextPosition(SwingConstants.CENTER);
    publicKeyPanel.setText("Ksdkdfkmsdfkm34ksdfm34");
    this.setBorder(border1);
    this.setMinimumSize(new Dimension(123, 35));
    this.setPreferredSize(new Dimension(123, 40));
    this.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mousePressed(MouseEvent e) {
        this_mousePressed(e);
      }
    });
    slotInfoLabel.setFont(new java.awt.Font("Monospaced", 0, 9));
    slotInfoLabel.setForeground(Color.black);
    slotInfoLabel.setMinimumSize(new Dimension(15, 10));
    slotInfoLabel.setPreferredSize(new Dimension(15, 10));
    slotInfoLabel.setText("000");
    showInfoMenuItem.setText("show information about this user");
    showInfoMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        showInfoMenuItem_actionPerformed(e);
      }
    });
    stopListeningMenuItem.setText("stop requesting from this channel");
    stopListeningMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        stopListeningMenuItem_actionPerformed(e);
      }
    });
    startListeningMenuItem.setText("start requesting from this channel");
    startListeningMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        startListeningMenuItem_actionPerformed(e);
      }
    });
    jPanel1.setLayout(borderLayout1);
    nickNamePanel.setMinimumSize(new Dimension(24, 15));
    nickNamePanel.setPreferredSize(new Dimension(24, 15));
    nickNamePanel.setHorizontalAlignment(SwingConstants.LEFT);
    nickNamePanel.setIconTextGap(0);
    nickNamePanel.setText("nick");
    lastOnlineLabel.setFont(new java.awt.Font("Dialog", 0, 9));
    lastOnlineLabel.setText("n/a");
    sendBufferdInsertsMenuitem.setText("send buffered inserts now");
    sendBufferdInsertsMenuitem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        sendBufferdInsertsMenuitem_actionPerformed(e);
      }
    });
    showInfoMenuItem1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        showInfoMenuItem1_actionPerformed(e);
      }
    });
    showInfoMenuItem1.setText("show information about this user");
    borderLayout1.setHgap(4);
    this.add(slotInfoLabel, BorderLayout.CENTER);
    this.add(jPanel1,  BorderLayout.NORTH);
    jPanel1.add(nickNamePanel, BorderLayout.CENTER);
    jPanel1.add(lastOnlineLabel,  BorderLayout.EAST);
    jPanel1.add(ratingPanel1,  BorderLayout.WEST);
    this.add(publicKeyPanel,  BorderLayout.SOUTH);
    contactPanelPopupMenu.add(showInfoMenuItem);
    contactPanelPopupMenu.add(showInfoMenuItem1);
    contactPanelPopupMenu.add(startListeningMenuItem);
    contactPanelPopupMenu.add(stopListeningMenuItem);
    sendingChannelPopupMenu.add(showInfoMenuItem);
    sendingChannelPopupMenu.add(sendBufferdInsertsMenuitem);
  }


  void showInfoMenuItem_actionPerformed(ActionEvent e) {
    BetaGUI.instance().newFrame("contact information for "+this.nickNamePanel.getText(), new ContactInformationPanel(this.contactInformation));
  }

  void this_mousePressed(MouseEvent e) {

    if (javax.swing.SwingUtilities.isRightMouseButton(e)) {
      if (this.contactInformation.getPublicKey().equals(freenetmessageboard.core.PersonalInfo.instance().getPublicKey())) {
        this.sendingChannelPopupMenu.show(this, e.getX(), e.getY());
      } else  {
        this.contactPanelPopupMenu.show(this, e.getPoint().x, e.getPoint().y);
      }
    }
  }

  static java.util.Comparator getNickNameComparator() {
    return new java.util.Comparator() {
      public int compare(Object o1, Object o2) {
        ContactPanel p1 = (ContactPanel)o1;
        ContactPanel p2 = (ContactPanel)o2;
        return p1.contactInformation.getNickname().compareTo(p2.contactInformation.getNickname());
      }
    };
  }

  static java.util.Comparator getLastActivityComparator() {
    return new java.util.Comparator() {
      public int compare(Object o1, Object o2) {
        ContactPanel p1 = (ContactPanel)o1;
        ContactPanel p2 = (ContactPanel)o2;
        Long t1 = new Long(p1.contactInformation.getTimeOfLastActivity());
        Long t2 = new Long(p2.contactInformation.getTimeOfLastActivity());
        return -t1.compareTo(t2);
      }
    };
  }

  static java.util.Comparator getRatingScoreComparator() {
    return new java.util.Comparator() {
      public int compare(Object o1, Object o2) {
        ContactPanel p1 = (ContactPanel)o1;
        ContactPanel p2 = (ContactPanel)o2;
        Integer t1 = new Integer(p1.contactInformation.getRatingScore());
        Integer t2 = new Integer(p2.contactInformation.getRatingScore());
        return -t1.compareTo(t2);
      }
    };
  }

  void startListeningMenuItem_actionPerformed(ActionEvent e) {
    freenetmessageboard.core.MessageGateway.instance().startListeningOnPersonalChannel(this.contactInformation.getPublicKey());
  }

  void stopListeningMenuItem_actionPerformed(ActionEvent e) {
    freenetmessageboard.core.MessageGateway.instance().stopListeningOnPersonalChannel(this.contactInformation.getPublicKey());

  }

  void sendBufferdInsertsMenuitem_actionPerformed(ActionEvent e) {
    freenetmessageboard.core.MessageGateway.instance().flushPersonalChannelMessageBuffer();
  }
  void showInfoMenuItem1_actionPerformed(ActionEvent e) {
    BetaGUI.instance().newFrame("contact information for "+this.nickNamePanel.getText(), new ContactInformationPanel(this.contactInformation));
  }
}