package freenetmessageboard.gui;

import java.awt.*;
import javax.swing.*;

import freenetmessageboard.core.CoreLogger;
import java.awt.event.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class ContactListPanel extends JPanel {
  BorderLayout contactListBorderLayout = new BorderLayout();
  JScrollPane contactsScrollPane = new JScrollPane();

  private final static int SORT_NOSORT = 0;
  private final static int SORT_NICKSORT = 1;
  private final static int SORT_LASTMSGSORT = 2;
  private final static int SORT_RATINGSORT = 3;

  private int currentSorting = SORT_NOSORT;

  private final static String[] SORT_DESCRIPTIONS = { "sort contact list...", "sort by nick", "sort by last activity", "sort by ratings" };

  private java.util.Map allContactPanelsMap = new java.util.HashMap();
  JPanel announcementChannelStatusPanel = new JPanel();
  BorderLayout announcementChannelStatusPanelBorderLayout = new BorderLayout();
  JLabel announcementChannelStatusCaptionLabel = new JLabel();
  JLabel announcementChannelStatusLabel = new JLabel();
  GridLayout contactsPanelGridLayout = new GridLayout();
  JPanel contactsPanel = new JPanel();
  JLabel slotInfoLabel = new JLabel();
  JPopupMenu announcementChannelPopupMenu = new JPopupMenu();
  JMenuItem startListeningMenuItem = new JMenuItem();
  JMenuItem stopListeningMenuItem = new JMenuItem();
  JPanel topPanel = new JPanel();
  JLabel headerLabel = new JLabel();
  BorderLayout topPanelBorderLayout1 = new BorderLayout();
  JComboBox sortByComboBox = new JComboBox();

  public ContactListPanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    Thread updateThread = new Thread() {
      public void run() {
        while(true) {
          try {
            Thread.sleep(30000);
          }
          catch (InterruptedException ex) {
          }
          CoreLogger.log("updating contact list panel...", CoreLogger.LOG_INFO);
          synchronized(ContactListPanel.this.allContactPanelsMap) {
            java.util.Iterator it = ContactListPanel.this.allContactPanelsMap.values().iterator();
            while (it.hasNext()) {
              ContactPanel p = (ContactPanel)it.next();
              p.updateInformation();
            }
          }
          CoreLogger.log("updating done...", CoreLogger.LOG_INFO);
        }
      }
    };
    updateThread.setName("ContactListUpdater");
    updateThread.start();
  }

  public void addNewContactPanel(freenetmessageboard.core.ContactInformation contactInfo) {
    CoreLogger.log("adding new panel for "+contactInfo.getNickname(), CoreLogger.LOG_NORMAL);
    synchronized (this.allContactPanelsMap) {
      ContactPanel panel = new ContactPanel(contactInfo);
      this.allContactPanelsMap.put(contactInfo.getPublicKey(), panel);
      this.contactsPanel.add(panel);
      if (this.allContactPanelsMap.size() > this.contactsPanelGridLayout.getRows()) {
        this.contactsPanelGridLayout.setRows(this.allContactPanelsMap.size());
      }
    }
    this.validate();
    this.repaint();
  }

  void updateAllContactPanels() {
    synchronized (this.allContactPanelsMap) {
      java.util.Iterator it = this.allContactPanelsMap.values().iterator();
      ContactPanel panel = (ContactPanel)it.next();
      panel.updateInformation();
    }
  }

  void updateContactPanel(String publicKey) {
    final ContactPanel panel = (ContactPanel)this.allContactPanelsMap.get(publicKey);
    if (panel==null) {
      return;
    }
    CoreLogger.log("updating "+panel.nickNamePanel.getText()+"'s channel status...", CoreLogger.LOG_INFO);
    Thread thread = new Thread() {
      public void run() {
        panel.updateInformation();
      }
    };
    thread.setName("ContactPanelUpdateThread");
    thread.start();
  }

  public void setAnnouncementChannelStatusString(String statusString, String slotInfoString) {
    this.announcementChannelStatusLabel.setText(statusString);
    this.slotInfoLabel.setText(slotInfoString);
  }

  private void sortContactList(int sortingMode) {
    if (sortingMode==this.SORT_NOSORT) return;

    this.currentSorting=sortingMode;

    java.util.List allContactPanelsList = new java.util.LinkedList(this.allContactPanelsMap.values());

    if (sortingMode==this.SORT_NICKSORT) {
      CoreLogger.log("sorting contact list by nick...", CoreLogger.LOG_NORMAL);
      java.util.Collections.sort(allContactPanelsList, ContactPanel.getNickNameComparator());
    }
    if (sortingMode==this.SORT_LASTMSGSORT) {
      CoreLogger.log("sorting contact list by last activity...", CoreLogger.LOG_NORMAL);
      java.util.Collections.sort(allContactPanelsList, ContactPanel.getLastActivityComparator());
    }
    if (sortingMode==this.SORT_RATINGSORT) {
      CoreLogger.log("sorting contact list by rating...", CoreLogger.LOG_NORMAL);
      java.util.Collections.sort(allContactPanelsList, ContactPanel.getRatingScoreComparator());
    }
    synchronized(this.contactsPanel) {
      this.contactsPanel.removeAll();
      for (int i=0; i<allContactPanelsList.size(); i++) {
        ((ContactPanel)allContactPanelsList.get(i)).updateInformation();
        this.contactsPanel.add((ContactPanel)allContactPanelsList.get(i));
      }
    }
    this.contactsPanel.validate();
    this.contactsPanel.repaint();
  }

  private void jbInit() throws Exception {
    this.setLayout(contactListBorderLayout);
    announcementChannelStatusPanel.setLayout(announcementChannelStatusPanelBorderLayout);
    announcementChannelStatusCaptionLabel.setText("announcement channel:");
    announcementChannelStatusLabel.setFont(new java.awt.Font("Dialog", 0, 9));
    announcementChannelStatusLabel.setForeground(Color.black);
    announcementChannelStatusLabel.setText("not listening");
    contactsPanelGridLayout.setRows(12);
    contactsPanelGridLayout.setColumns(1);
    contactsPanel.setLayout(contactsPanelGridLayout);
    this.setMinimumSize(new Dimension(200, 69));
    this.setPreferredSize(new Dimension(200, 65));
    slotInfoLabel.setFont(new java.awt.Font("Monospaced", 0, 9));
    slotInfoLabel.setForeground(Color.black);
    slotInfoLabel.setText("000");
    startListeningMenuItem.setText("start listening on announcement channel");
    startListeningMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        startListeningMenuItem_actionPerformed(e);
      }
    });
    stopListeningMenuItem.setText("stop listening on announcement channel");
    stopListeningMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        stopListeningMenuItem_actionPerformed(e);
      }
    });
    announcementChannelStatusPanel.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mousePressed(MouseEvent e) {
        announcementChannelStatusPanel_mousePressed(e);
      }
    });
    headerLabel.setHorizontalAlignment(SwingConstants.CENTER);
    headerLabel.setText("contact list");
    topPanel.setLayout(topPanelBorderLayout1);
    sortByComboBox.setFont(new java.awt.Font("Dialog", 0, 9));
    sortByComboBox.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(MouseEvent e) {
        sortByComboBox_mouseClicked(e);
      }
      public void mousePressed(MouseEvent e) {
        sortByComboBox_mousePressed(e);
      }
    });
    sortByComboBox.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        sortByComboBox_itemStateChanged(e);
      }
    });
    this.add(contactsScrollPane, BorderLayout.CENTER);
    contactsScrollPane.getViewport().add(contactsPanel, null);
    this.add(announcementChannelStatusPanel,  BorderLayout.SOUTH);
    announcementChannelStatusPanel.add(announcementChannelStatusLabel, BorderLayout.CENTER);
    announcementChannelStatusPanel.add(slotInfoLabel, BorderLayout.SOUTH);
    announcementChannelStatusPanel.add(announcementChannelStatusCaptionLabel, BorderLayout.NORTH);
    this.add(topPanel, BorderLayout.NORTH);
    topPanel.add(headerLabel, BorderLayout.CENTER);
    announcementChannelPopupMenu.add(startListeningMenuItem);
    announcementChannelPopupMenu.add(stopListeningMenuItem);

    topPanel.add(sortByComboBox, BorderLayout.SOUTH);
    for (int i=0; i<this.SORT_DESCRIPTIONS.length; i++) {
      this.sortByComboBox.addItem(this.SORT_DESCRIPTIONS[i]);
    }
  }

  void stopListeningMenuItem_actionPerformed(ActionEvent e) {
    freenetmessageboard.core.MessageGateway.instance().stopListeningOnPublicAnnouncementChannel();
  }

  void startListeningMenuItem_actionPerformed(ActionEvent e) {
    freenetmessageboard.core.MessageGateway.instance().startListeningOnPublicAnnouncementChannel();
  }


  void announcementChannelStatusPanel_mousePressed(MouseEvent e) {
    if (javax.swing.SwingUtilities.isRightMouseButton(e)) {
      this.announcementChannelPopupMenu.show(this.announcementChannelStatusPanel, e.getPoint().x, e.getPoint().y);
    }
  }

  void sortByComboBox_itemStateChanged(ItemEvent e) {
    CoreLogger.log("Item stated changed: "+e.getStateChange(), CoreLogger.LOG_NORMAL);
    this.sortContactList(this.sortByComboBox.getSelectedIndex());
  }

  void sortByComboBox_mouseClicked(MouseEvent e) {

  }

  void sortByComboBox_mousePressed(MouseEvent e) {

  }

}