package freenetmessageboard.gui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class ContactInformationPanel extends JPanel {
  BorderLayout mainBorderLayout = new BorderLayout();
  JPanel topPanel = new JPanel();
  JPanel bottomPanel = new JPanel();
  JPanel mainPanel = new JPanel();
  JSplitPane mainSlitPane = new JSplitPane();
  BorderLayout mainPanelBorderLayout = new BorderLayout();
  JPanel userMessagesPanel = new JPanel();
  JPanel commentsMessagesPanel = new JPanel();
  BorderLayout commentsMessagesPanelBorderLayout = new BorderLayout();
  JLabel commentsCaptionLabel = new JLabel();
  JLabel userMessagesCaptionLabel = new JLabel();
  JTabbedPane userMessagesTabbedPane = new JTabbedPane();
  JTabbedPane commentsMessagesTabbedPane = new JTabbedPane();
  BorderLayout userMessagesPanelBorderLayout = new BorderLayout();
  JPanel defaultDescriptionsPanel = new JPanel();
  JPanel defaultCommentsPanel = new JPanel();
  JLabel noCommentsLabel = new JLabel();
  BorderLayout bottomPanelBorderLayout = new BorderLayout();
  freenetmessageboard.core.ContactInformation information;
  JButton refreshButton = new JButton();

  public ContactInformationPanel(freenetmessageboard.core.ContactInformation info) {
    this();
    this.information=info;
    this.updateInformation();
  }

  void updateInformation() {
    freenetmessageboard.core.UserMessage[] userMsgs = this.information.getUserMessages();
    this.userMessagesTabbedPane.removeAll();
    for (int i=0; i<userMsgs.length; i++) {
      if (i>4) break;
      this.userMessagesTabbedPane.add(new UserMessagePanel(userMsgs[i]));
      this.userMessagesTabbedPane.setTitleAt(i, userMsgs[i].getDate());
    }
    this.userMessagesTabbedPane.validate();
    freenetmessageboard.core.UserCommentMessage[] commentMsgs = this.information.getUserCommentMessages();
    boolean ownCommentExists=false;
    this.commentsMessagesTabbedPane.removeAll();
    if (commentMsgs.length>0) {
      this.commentsMessagesTabbedPane.removeAll();
      for (int i=0; i<commentMsgs.length; i++) {
        if (commentMsgs[i].getOriginalPublicKey().equals(freenetmessageboard.core.PersonalInfo.instance().getPublicKey())) {
          this.commentsMessagesTabbedPane.add(new UserCommentMessagePanel(commentMsgs[i], true), i);
          this.commentsMessagesTabbedPane.setTitleAt(i, "your comment");
          this.commentsMessagesTabbedPane.setIconAt(i, ColorsAndIcons.getIconForRating(commentMsgs[i].getRating()));
          ownCommentExists=true;
        } else {
          this.commentsMessagesTabbedPane.add(new UserCommentMessagePanel(commentMsgs[i]));
          this.commentsMessagesTabbedPane.setTitleAt(i, freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(commentMsgs[i].getOriginalPublicKey()));
          this.commentsMessagesTabbedPane.setIconAt(i, ColorsAndIcons.getIconForRating(commentMsgs[i].getRating()));
        }
      }
    }
    if (ownCommentExists==false && this.information.getPublicKey().equals(freenetmessageboard.core.PersonalInfo.instance().getPublicKey())==false) {
      this.commentsMessagesTabbedPane.add(new UserCommentMessagePanel(this.information.getPublicKey(), true), commentMsgs.length);
      this.commentsMessagesTabbedPane.setTitleAt(commentMsgs.length, "your comment");
      this.commentsMessagesTabbedPane.setIconAt(commentMsgs.length, ColorsAndIcons.getIconForRating("any"));

    }
    this.repaint();
  }

  public ContactInformationPanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  private void jbInit() throws Exception {
    this.setLayout(mainBorderLayout);
    mainSlitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
    mainPanel.setLayout(mainPanelBorderLayout);
    commentsMessagesPanel.setLayout(commentsMessagesPanelBorderLayout);
    commentsCaptionLabel.setOpaque(true);
    commentsCaptionLabel.setText("comments from other users:");
    userMessagesCaptionLabel.setOpaque(true);
    userMessagesCaptionLabel.setText("self descriptions from this user:");
    userMessagesPanel.setLayout(userMessagesPanelBorderLayout);
    noCommentsLabel.setText("no comments have been received on this user");
    this.setMaximumSize(new Dimension(800, 600));
    this.setMinimumSize(new Dimension(300, 200));
    this.setPreferredSize(new Dimension(400, 300));
    userMessagesTabbedPane.setBackground(UIManager.getColor("Panel.background"));
    userMessagesTabbedPane.setForeground(new Color(102, 102, 153));
    userMessagesTabbedPane.setOpaque(true);
    commentsMessagesTabbedPane.setBackground(UIManager.getColor("Panel.background"));
    commentsMessagesTabbedPane.setForeground(new Color(102, 102, 153));
    commentsMessagesTabbedPane.setOpaque(true);
    bottomPanel.setLayout(bottomPanelBorderLayout);
    refreshButton.setFont(new java.awt.Font("Dialog", 0, 9));
    refreshButton.setText("refresh self-descriptions and comments");
    refreshButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        refreshButton_actionPerformed(e);
      }
    });
    this.add(topPanel, BorderLayout.NORTH);
    this.add(bottomPanel, BorderLayout.SOUTH);
    bottomPanel.add(refreshButton, BorderLayout.CENTER);
    this.add(mainPanel, BorderLayout.CENTER);
    mainPanel.add(mainSlitPane,  BorderLayout.CENTER);
    mainSlitPane.add(userMessagesPanel, JSplitPane.TOP);
    mainSlitPane.add(commentsMessagesPanel, JSplitPane.BOTTOM);
    commentsMessagesPanel.add(commentsCaptionLabel, BorderLayout.NORTH);
    userMessagesPanel.add(userMessagesCaptionLabel, BorderLayout.NORTH);
    userMessagesPanel.add(userMessagesTabbedPane, BorderLayout.CENTER);
    userMessagesTabbedPane.add(defaultDescriptionsPanel, "jPanel1");
    commentsMessagesPanel.add(commentsMessagesTabbedPane,  BorderLayout.CENTER);
    commentsMessagesTabbedPane.add(defaultCommentsPanel,  "no comments");
    defaultCommentsPanel.add(noCommentsLabel, null);
  }

  void refreshButton_actionPerformed(ActionEvent e) {
    this.updateInformation();
  }
}