package freenetmessageboard.gui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class ChessLoungepanel extends JPanel {
  BorderLayout mainBorderLayout = new BorderLayout();
  JScrollPane currentGamesScrollPane;
  JPanel bottomPanel = new JPanel();
  JButton startGameButton = new JButton();
  JComboBox opponentComboBox;
  BorderLayout bottomPanelBorderLayout = new BorderLayout();
  JButton addToOpponentListButton = new JButton();
  JTable currentGamesTable;
  JPopupMenu chessGamesPopUpMenu = new JPopupMenu();
  JMenuItem showGameMenuItem = new JMenuItem();
  JCheckBox showGamesCheckBox = new JCheckBox();

  public ChessLoungepanel() {
    this.opponentComboBox = new JComboBox(freenetmessageboard.core.ChessLounge.instance());
    TableSorter sorter = new TableSorter(freenetmessageboard.core.ChessLounge.instance());
    this.currentGamesTable = new JTable(sorter);
    sorter.addMouseListenerToHeaderInTable(this.currentGamesTable);

    this.currentGamesScrollPane=new JScrollPane(this.currentGamesTable);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }

  }
  private void jbInit() throws Exception {
    this.setLayout(mainBorderLayout);
    startGameButton.setFont(new java.awt.Font("Dialog", 0, 10));
    startGameButton.setText("play game");
    startGameButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        startGameButton_actionPerformed(e);
      }
    });
    bottomPanel.setLayout(bottomPanelBorderLayout);
    addToOpponentListButton.setFont(new java.awt.Font("Dialog", 0, 10));
    addToOpponentListButton.setText("add me to that list");
    addToOpponentListButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        addToOpponentListButton_actionPerformed(e);
      }
    });
    opponentComboBox.setFont(new java.awt.Font("Dialog", 0, 10));
    currentGamesTable.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mousePressed(MouseEvent e) {
        currentGamesTable_mousePressed(e);
      }
    });
    showGameMenuItem.setText("show this game");
    showGameMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        showGameMenuItem_actionPerformed(e);
      }
    });
    showGamesCheckBox.setHorizontalAlignment(SwingConstants.CENTER);
    showGamesCheckBox.setText("show a popup frame whenever it\'s my turn in a game");
    showGamesCheckBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        showGamesCheckBox_actionPerformed(e);
      }
    });
    this.add(currentGamesScrollPane, BorderLayout.CENTER);
    currentGamesScrollPane.getViewport().add(currentGamesTable, null);
    this.add(bottomPanel, BorderLayout.NORTH);
    bottomPanel.add(opponentComboBox,  BorderLayout.WEST);
    bottomPanel.add(startGameButton, BorderLayout.CENTER);
    bottomPanel.add(addToOpponentListButton, BorderLayout.EAST);
    this.add(showGamesCheckBox,  BorderLayout.SOUTH);
    chessGamesPopUpMenu.add(showGameMenuItem);
  }

  void addToOpponentListButton_actionPerformed(ActionEvent e) {
    freenetmessageboard.core.ChessMessage chessMsg = new freenetmessageboard.core.ChessMessage();
    freenetmessageboard.core.MessageGateway.instance().sendMessageOnPersonalChannel(chessMsg);
  }

  void startGameButton_actionPerformed(ActionEvent e) {
    try {
      Object o = this.opponentComboBox.getModel().getSelectedItem();
      if ((o instanceof freenetmessageboard.core.ChessMessage)== false) { return; }
      String publicKey = ((freenetmessageboard.core.ChessMessage)o).getBlackKey();
      freenetmessageboard.schach.SchachSpiel spiel = new freenetmessageboard.schach.SchachSpiel(publicKey);
      freenetmessageboard.schach.SchachTestFrame frame = new freenetmessageboard.schach.SchachTestFrame(spiel);
    } catch (Throwable t) {
      t.printStackTrace();
    }
  }


  void currentGamesTable_mousePressed(MouseEvent e) {
    if (javax.swing.SwingUtilities.isRightMouseButton(e)) {
      if (this.currentGamesTable.getSelectedRow()!=-1) {
        this.chessGamesPopUpMenu.show(this.currentGamesTable, e.getX(), e.getY());
      }
    }
  }

  void showGameMenuItem_actionPerformed(ActionEvent e) {
    int row = ((TableSorter)this.currentGamesTable.getModel()).getRealIndex(this.currentGamesTable.getSelectedRow());
    if (row!=-1) {
      freenetmessageboard.core.ChessLounge.instance().showGame(row);
    }
  }

  void showGamesCheckBox_actionPerformed(ActionEvent e) {
    freenetmessageboard.core.ChessLounge.instance().informMeWhenItsMyTurn(this.showGamesCheckBox.isSelected());
  }
}