package freenetmessageboard.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import javax.swing.tree.MutableTreeNode;
import javax.swing.event.*;

import freenetmessageboard.core.NewsgroupPost;

import freenetmessageboard.core.CoreLogger;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class BoardContentPanel extends JPanel {

  JTabbedPane mainTabbedPane = new JTabbedPane();
  BorderLayout mainBorderLayout = new BorderLayout();
  JButton newMessageButton = new JButton();
  JScrollPane treeViewScrollPane = new JScrollPane();
  JScrollPane tableViewScrollPane = new JScrollPane();

  JTable postsTable = new JTable();
  JTree postsTree = new JTree();

  boolean isMouseDown=false;
  int lastSelectedMsg=-1;
  JPanel archivePanel = new JPanel();
  JScrollPane archiveScrollPane = new JScrollPane();
  JTable archivesTable = new JTable();
  BorderLayout archivePanelBorderLayout = new BorderLayout();
  JButton insertArchiveButton = new JButton();
  JPopupMenu archiveRequestsPopupMenu = new JPopupMenu();
  JMenuItem requestArchiveMenuItem = new JMenuItem();

  boolean treeViewSelected=true;
  ChessLoungepanel chessLoungepanel1 = new ChessLoungepanel();

  public BoardContentPanel() {
    try {
      jbInit();
      TableSorter sorter = new TableSorter(freenetmessageboard.core.NewsgroupDataModel.instance());
      sorter.addMouseListenerToHeaderInTable(this.postsTable);
      this.postsTable.setModel(sorter);
      this.postsTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
      this.postsTable.setAutoResizeMode(this.postsTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
      this.postsTable.getColumnModel().getColumn(0).setPreferredWidth(20);
      this.postsTable.getColumnModel().getColumn(0).setMaxWidth(20);
      this.postsTable.getColumnModel().getColumn(1).setPreferredWidth(75);
      this.postsTable.getColumnModel().getColumn(1).setMaxWidth(250);
      this.postsTable.getColumnModel().getColumn(2).setPreferredWidth(120);
      this.postsTable.getColumnModel().getColumn(2).setMaxWidth(600);
      this.postsTable.getColumnModel().getColumn(3).setPreferredWidth(140);
      this.postsTable.getColumnModel().getColumn(3).setMaxWidth(140);
      this.postsTable.getColumnModel().getColumn(4).setPreferredWidth(80);
      this.postsTable.getColumnModel().getColumn(4).setMaxWidth(200);
  //    TableSorter sorter2 = new TableSorter(freenetmessageboard.core.MessageArchiveReceiver.instance());
  //    sorter2.addMouseListenerToHeaderInTable(this.archivesTable);
      this.archivesTable.setModel(freenetmessageboard.core.MessageArchiveReceiver.instance());
      this.archivesTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
      this.archivesTable.getColumnModel().getColumn(2).setPreferredWidth(30);
      this.archivesTable.getColumnModel().getColumn(2).setMaxWidth(40);
      this.archivesTable.getColumnModel().getColumn(3).setPreferredWidth(30);
      this.archivesTable.getColumnModel().getColumn(3).setMaxWidth(40);
      this.archivesTable.getColumnModel().getColumn(4).setPreferredWidth(40);
      this.archivesTable.getColumnModel().getColumn(4).setMaxWidth(50);
      this.postsTree.setModel(freenetmessageboard.core.NewsgroupDataModel.instance());
      this.postsTree.setCellRenderer(new NewsgroupPostTreeCellRenderer());
      this.addTreeSelectionListener();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

/*  public void repaint() {
    try {
      synchronized(this.postsTree.getModel().getRoot()) {
        super.repaint();
      }
    } catch (Throwable t) {
      super.repaint();
    }
  }*/

  private void addTreeSelectionListener() {
    this.postsTree.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
      public void valueChanged(javax.swing.event.TreeSelectionEvent e) {
        try {
          javax.swing.JTree tree = (javax.swing.JTree)e.getSource();
          NewsgroupPost node = (NewsgroupPost)tree.getLastSelectedPathComponent();
          if (node==null) return;
          freenetmessageboard.core.CoreLogger.log("selected node: "+node.toString(), freenetmessageboard.core.CoreLogger.LOG_NORMAL);
          if (node.getPostMessage()!=null) {
            BetaGUI.instance().showPostMessage(node.getPostMessage());
          }


        } catch (Throwable t) {
          freenetmessageboard.core.CoreLogger.log("exception while getting selected node: "+t.getClass()+": "+t.getMessage(), freenetmessageboard.core.CoreLogger.LOG_ERROR);
        }
      }
    });
  }

  private void jbInit() throws Exception {
    this.setLayout(mainBorderLayout);
    newMessageButton.setText("create new message");
    newMessageButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        newMessageButton_actionPerformed(e);
      }
    });
    postsTable.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mousePressed(MouseEvent e) {
        postsTable_mousePressed(e);
      }
      public void mouseReleased(MouseEvent e) {
        postsTable_mouseReleased(e);
      }
    });
    archivePanel.setLayout(archivePanelBorderLayout);
    insertArchiveButton.setFont(new java.awt.Font("Dialog", 0, 9));
    insertArchiveButton.setText("insert message archive");
    insertArchiveButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        insertArchiveButton_actionPerformed(e);
      }
    });
    requestArchiveMenuItem.setText("request archive");
    requestArchiveMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        requestArchiveMenuItem_actionPerformed(e);
      }
    });
    archivesTable.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mousePressed(MouseEvent e) {
        archivesTable_mousePressed(e);
      }
    });
    mainTabbedPane.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(ChangeEvent e) {
        mainTabbedPane_stateChanged(e);
      }
    });
    this.add(mainTabbedPane,  BorderLayout.CENTER);
    mainTabbedPane.add(treeViewScrollPane,  "tree view");
    mainTabbedPane.add(tableViewScrollPane,  "table view");
    mainTabbedPane.add(archivePanel,  "archives");
    mainTabbedPane.add(chessLoungepanel1,  "chess lounge");
    this.add(newMessageButton,  BorderLayout.SOUTH);
    tableViewScrollPane.getViewport().add(postsTable, null);
    treeViewScrollPane.getViewport().add(postsTree, null);
    archivePanel.add(archiveScrollPane,  BorderLayout.CENTER);
    archiveScrollPane.getViewport().add(archivesTable, null);
    archivePanel.add(insertArchiveButton, BorderLayout.SOUTH);

    chessLoungepanel1.validate();
    archiveRequestsPopupMenu.add(requestArchiveMenuItem);
  }

  void newMessageButton_actionPerformed(ActionEvent e) {
    PostMessagePanel panel = new PostMessagePanel();
    panel.setEditable(true);
    BetaGUI.instance().newFrame("create new message", panel);
  }

  void postsTable_mouseReleased(MouseEvent e) {
    this.isMouseDown=false;
    this.showSelectedMessage();
  }

  void showSelectedMessage() {
    int row = ((TableSorter)this.postsTable.getModel()).getRealIndex(this.postsTable.getSelectedRow());
    if (row!=this.lastSelectedMsg) {
      this.lastSelectedMsg=row;
      if (row<0 || row>=this.postsTable.getModel().getRowCount()) return;
      BetaGUI.instance().showPostMessage(freenetmessageboard.core.NewsgroupDataModel.instance().getPostMessageInRow(row));
    }
  }

  void postsTable_mousePressed(MouseEvent e) {
    this.isMouseDown=true;
    this.showSelectedMessage();
  }

  void insertArchiveButton_actionPerformed(ActionEvent e) {
    try {
      freenetmessageboard.core.MessageArchive archive = freenetmessageboard.core.MessagePool.instance().createArchive(freenetmessageboard.core.MessageFilter.originalNonArchiveMessagesOnlyFilter());
      freenetmessageboard.core.MessageArchiveTransmitter.instance().insertArchive(archive, freenetmessageboard.core.MessageGateway.uriDateFormat.format(new java.util.Date()));
      this.insertArchiveButton.setText("inserting...");
      this.insertArchiveButton.setEnabled(false);
    } catch (Throwable t) {
      this.insertArchiveButton.setText("failed to insert archive: "+t.getClass()+": "+t.getMessage());
    }
  }

  void requestArchiveMenuItem_actionPerformed(ActionEvent e) {
 //   int row = ((TableSorter)this.archivesTable.getModel()).getRealIndex(this.archivesTable.getSelectedRow());
    int row = this.archivesTable.getSelectedRow();
    if (row!=-1) {
      freenetmessageboard.core.MessageArchiveReceiver.instance().requestArchive(row);
    }

  }

  void archivesTable_mousePressed(MouseEvent e) {
    if (javax.swing.SwingUtilities.isRightMouseButton(e)) {
      if (this.archivesTable.getSelectedRow()!=-1) {
        this.archiveRequestsPopupMenu.show(this.archivesTable, e.getX(), e.getY());
      }
    }
  }

  void selectCurrentMessageInTreeView() {
    freenetmessageboard.core.PostMessage msg = BetaGUI.instance().getCurrentlyDisplayedPostMessage();
   if (msg==null) return;
    freenetmessageboard.core.NewsgroupPost node = freenetmessageboard.core.NewsgroupDataModel.instance().getTreeNodeForMessage(msg);
//    ((javax.swing.tree.DefaultTreeModel)this.postsTree.getModel()).getT
    javax.swing.tree.TreePath treePath = freenetmessageboard.core.NewsgroupDataModel.instance().getPathToRoot(node);
    this.postsTree.setSelectionPath(treePath);
    this.postsTree.expandRow(this.postsTree.getRowForPath(treePath));
    this.postsTree.scrollPathToVisible(treePath);
  }

  void mainTabbedPane_stateChanged(ChangeEvent e) {

    CoreLogger.log("switched the tabbed pane: "+e, CoreLogger.LOG_NORMAL);

    if (this.mainTabbedPane.getSelectedComponent().equals(this.treeViewScrollPane)) {
      if (treeViewSelected==false) {
        this.treeViewSelected=true;
        this.selectCurrentMessageInTreeView();
      }
    } else {
      this.treeViewSelected=false;
    }
  }
}