package freenetmessageboard.gui;

import freenetmessageboard.core.CoreLogger;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class BetaGUI implements GUIInterface{

  private static BetaGUI instance;

  private FMBMainFrame mainFrame = new FMBMainFrame();
  private javax.swing.tree.TreeCellRenderer treeCellRenderer = new NewsgroupPostTreeCellRenderer();
  java.awt.Dimension defaultFrameSize = new java.awt.Dimension(650,650);
  java.awt.Point defaultFrameLocation;

  boolean isActive=false;

  private  MessageVerificationFrame verificatonFrame = new MessageVerificationFrame();

  private freenetmessageboard.core.PostMessage displayedMessage;

  private BetaGUI() {
    this.mainFrame.setSize(800,600);
    this.mainFrame.setLocation(200,200);
    this.defaultFrameLocation=new java.awt.Point(this.mainFrame.getLocation().x+15, this.mainFrame.getLocation().y+15);
  }

  public void showPersonalInformationDialog(freenetmessageboard.core.PersonalInfo callback) {
    CoreLogger.log("creating personal info dialog", CoreLogger.LOG_WARNING);
    freenetmessageboard.gui.PersonalInfoDialog dialog = new freenetmessageboard.gui.PersonalInfoDialog(this.getMainFrame());
    dialog.publicKeyTextField.setText(callback.getPublicKey());
    dialog.privateKeyTextField.setText(callback.getPrivateKey());
    dialog.nickTextField.setText(callback.getNickname());
    dialog.nameTextField.setText(callback.getName());
    dialog.freesiteUriTextField.setText(callback.getFreesiteUri());
    dialog.interestsTextField.setText(callback.getInterests());
    dialog.descriptionTextArea.setText(callback.getDescription());
    dialog.messageTextArea.setText(callback.getMessage());
    CoreLogger.log("showing personal info dialog", CoreLogger.LOG_WARNING);
    dialog.show();
    if (dialog.wasCancelled()) {
      CoreLogger.log("the personal info dialog was cancelled", CoreLogger.LOG_INFO);
    } else {
      CoreLogger.log("the personal info dialog was confirmed", CoreLogger.LOG_INFO);
      callback.updateInfoFromDialog(dialog);
    }
  }

  public void activateGUI() {
    this.mainFrame.setVisible(true);
    this.isActive=true;
  }

  public FMBMainFrame getMainFrame() {
    return this.mainFrame;
  }

  public void verifyMessage(freenetmessageboard.core.Message msg1, freenetmessageboard.core.Message msg2) {
    this.verificatonFrame.verifyMessage(msg1, msg2);
    if (this.verificatonFrame.isVisible()==false) {
      this.verificatonFrame.setVisible(true);
    }
  }

  public void setVerifyingRating(freenetmessageboard.core.Message msg, String rating) {
    this.verificatonFrame.showVerificationRating(msg, rating);
  }

  public void removeVerification(freenetmessageboard.core.Message msg1) {
    this.verificatonFrame.removeMessage(msg1);
  }

  public void verifyMessage(freenetmessageboard.core.Message msg1) {
    this.verificatonFrame.verifyMessage(msg1);
    if (this.verificatonFrame.isVisible()==false) {
      this.verificatonFrame.setVisible(true);
    }
  }

  public void setInsertArchiveStatusString(String string, boolean enableButton) {
    if (enableButton) {
      this.mainFrame.boardContentPanel.insertArchiveButton.setEnabled(enableButton);
    }
    this.mainFrame.boardContentPanel.insertArchiveButton.setText(string);
  }

  public void showPanel(javax.swing.JPanel panel) {
    this.mainFrame.mainPanel.removeAll();
    this.mainFrame.mainPanel.add(panel, java.awt.BorderLayout.CENTER);
    this.mainFrame.validate();
    this.mainFrame.mainPanel.repaint();
  }

  freenetmessageboard.core.PostMessage getCurrentlyDisplayedPostMessage() {
    return this.displayedMessage;
  }

  public void showPostMessage(freenetmessageboard.core.PostMessage postMsg) {
    this.displayedMessage=postMsg;
    freenetmessageboard.core.NewsgroupDataModel.instance().markAsRead(postMsg.getUniqueId());
    if (this.mainFrame.mainPanel.getComponentCount()>0) {
      if (this.mainFrame.mainPanel.getComponent(0) instanceof PostMessagePanel) {
       ((PostMessagePanel)this.mainFrame.mainPanel.getComponent(0)).updateInformationFrom(postMsg);
       return;
      }
    }
    this.mainFrame.mainPanel.removeAll();
    this.mainFrame.mainPanel.add(new PostMessagePanel(postMsg, false));
    this.mainFrame.jSplitPane1.validate();
    this.mainFrame.mainPanel.repaint();
  }

  public void updateBoardContentView() {

  }

  javax.swing.tree.TreeCellRenderer getTreeCellRenderer() {
    return this.treeCellRenderer;
  }

  public void updateContactPanel(String publicKey) {
    if (this.isActive) {
      this.mainFrame.contactListPanel.updateContactPanel(publicKey);
    }
  }

  public void newFrame(String title, javax.swing.JPanel panel) {
    final javax.swing.JFrame frame = new javax.swing.JFrame(title);
    frame.addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent e) {
        (BetaGUI.instance()).defaultFrameSize=frame.getSize();
        (BetaGUI.instance()).defaultFrameLocation=frame.getLocation();
        frame.dispose();
      }
    });
    frame.getContentPane().add(panel);
    frame.setSize(this.defaultFrameSize);
    frame.setLocation(this.defaultFrameLocation);
    frame.show();
  }

  public boolean showConfirmDialog(String message, String title) {
    int  answer = javax.swing.JOptionPane.showConfirmDialog(this.mainFrame, message, title, javax.swing.JOptionPane.YES_NO_OPTION , javax.swing.JOptionPane.WARNING_MESSAGE);
    if (answer==javax.swing.JOptionPane.YES_OPTION) {
      return true;
    }
    return false;
  }

  public void addContactPanel(freenetmessageboard.core.ContactInformation info) {
    this.mainFrame.contactListPanel.addNewContactPanel(info);
  }

  public void setAnnouncementChannelStatusString(String statusString, String slotInfoString) {
    this.mainFrame.contactListPanel.setAnnouncementChannelStatusString(statusString, slotInfoString);
  }

  public ContactListPanel getContactListPanel() {
    return this.mainFrame.contactListPanel;
  }

  public static synchronized BetaGUI instance() {
    if (BetaGUI.instance==null) {
      try {
        javax.swing.UIManager.setLookAndFeel(javax.swing.UIManager.getInstalledLookAndFeels()[0].getClassName());
      } catch (Exception ex) {
        ex.printStackTrace();
      }
      BetaGUI.instance=new BetaGUI();

    }
    return BetaGUI.instance;
  }

}