package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

public class TestMain {

  public TestMain() {
  }
  public static void main(String[] args) {


    try {
      FCPConnectionHandler handler = new FCPConnectionHandler();
      handler.start();
      String version = handler.checkFreenetConnectionAndGetNodeVersion();
      System.err.println("Freenet Version: "+version);
      KeyPair keyPair = handler.generateKeyPair();
      String name="/dischwalla";
      String uri = "SSK@"+keyPair.getPrivateKey()+name;
      handler.startFreenetInsert(uri, 1, "text/plain".getBytes(), "Ich bins der Mann der alles kann".getBytes());
      while (handler.isFinished(uri)==false) {
        Thread.sleep(100);
      }
      InsertInfo insertInfo = handler.getInsertInfo(uri);
      String oldUri=insertInfo.getOriginalUri();
      System.err.println("ORIGINAL URI: "+oldUri);
      String newuri=insertInfo.getFinalUri();
      System.err.println("NEW URI: "+newuri);
      String pub = "SSK@"+keyPair.getPublicKey()+name;
      handler.startFreenetRequest(pub, 2);
      while (handler.isFinished(pub)==false) {
        Thread.sleep(100);
      }
      RequestedData data = handler.getRequestedData(pub);
      System.err.println("uri: "+data.getOriginalUri());
      System.err.println("redirect: "+data.getRedirectedUri());
      System.err.println("Meta: "+new String(data.getMetaBytes()));
      System.err.println("Data: "+new String(data.getDataBytes()));
    } catch (Exception e) {
      System.err.println(FCPUtils.getClassNameOnly(e)+": "+e.getMessage());
      e.printStackTrace();
    }
  }
}