package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

public class RequestedData {

  private String originalUri;
  private String redirectedUri;
  private byte[] dataBytes;
  private byte[] metaBytes;

  public RequestedData(String originalUri, FCPClientGetConnection connection) {
    this.originalUri=originalUri;
    this.redirectedUri=connection.uri;
    this.dataBytes=connection.getData();
    this.metaBytes=connection.getMetaData();
  }

  public String getOriginalUri() {
    return this.originalUri;
  }

  public String getRedirectedUri() {
    return this.redirectedUri;
  }

  public byte[] getDataBytes() {
    return this.dataBytes;
  }

  public byte[] getMetaBytes() {
    return this.metaBytes;
  }
}