package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

public class FreenetConnectionFailedException extends Exception {

  private String reason;
  private String solution;
  private int problem;
  private static String[] problems = { "an unexpeteced exception happened. you are allowed to call this a bug ;)",
                                       "the connection to the freenet node failed",
                                       "you asked for the status of a key which was never processed",
                                       "you were trying to get data from the connection handler before it was completely retrieved from freenet",
                                       "the node was unable to get the requested key from freenet",
                                       "i recieved a response from the node which i don't really understand",
                                       "failed to insert the data into freenet",
                                       "not a valid freenet host address",
                                       "ssk inserts cannot be larger than 32kb",
                                       "key collision at insert",
                                       "format error in uri",
                                       "your node can't connect to the freenet network"};
  public final static int UNEXPECTED_EXCEPTION = 0;
  public final static int CANNOT_CONNECT_TO_FREENET_NODE = 1;
  public final static int KEY_NOT_RECOGNIZED = 2;
  public final static int TRANSACTION_NOT_FINISHED_YET = 3;
  public final static int DATA_NOT_FOUND = 4;
  public final static int UNKNOWN_RESPONSE = 5;
  public final static int INSERT_FAILED = 6;
  public final static int HOSTADRESS_FORMAT_ERROR = 7;
  public final static int SSK_INSERT_TOO_BIG = 8;
  public final static int KEY_COLLISION = 9;
  public final static int URI_FORMAT_ERROR = 10;
  public final static int ROUTE_NOT_FOUND = 11;

  public FreenetConnectionFailedException(int problem, String reason, String solution) {
    this.problem=problem;
    this.reason=reason;
    this.solution=solution;
  }

  public String getReason() {
    return this.reason;
  }

  public String getProblem() {
    return FreenetConnectionFailedException.problems[this.problem];
  }

  public String getMessage() {
   return this.getReason();
  }

  public int getProblemCode() {
    return this.problem;
  }

  public String getSolution() {
    return this.solution;
  }

  public void log() {
    System.err.println("PROBLEM:"+this.problems[this.problem]);
    System.err.println("REASON:"+this.reason);
    System.err.println("SOLUTION:"+this.solution);
  }
}