package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPUtils {

  static boolean checkUriSyntax(String uri) {
    try {
      String shortUri = uri.toLowerCase();
      if (shortUri.startsWith("freenet:")) {
        shortUri=shortUri.substring(shortUri.indexOf(":")+1);
      }
      if (uri.indexOf("@")>=0) {
        if (shortUri.startsWith("msk@")) {
          shortUri=shortUri.substring(shortUri.indexOf(":")+1);
        }
        if (shortUri.startsWith("ksk@")) return true;
        if (shortUri.startsWith("chk@")) return true;
        if (shortUri.startsWith("ssk@")) return true;
        return false;
      }
      return true;
    } catch (java.lang.NullPointerException e) {
      System.err.println("NullPointerException while parsing "+uri);
      return false;
    }

  }

  static FCPResponse parseResponse(byte[] responseBytes) throws ResponseNotReadableException, ResponseNotKnownException, BadMessageFormatException {
    String header = FCPUtils.getMessageHeader(responseBytes);
    FCPResponse response;
    if (header.equals(FCPMessage.nodeHelloMessageHeader)) {
      return new FCPNodeHelloMessage(responseBytes);
    }
    if (header.equals(FCPMessage.successHeader)) {
      return new FCPSuccessMessage(responseBytes);
    }
    if (header.equals(FCPMessage.failedHeader)) {
      return new FCPFailedMessage(responseBytes);
    }
    if (header.equals(FCPMessage.pendingHeader)) {
      return new FCPPendingMessage(responseBytes);
    }
    if (header.equals(FCPMessage.formatErrorHeader)) {
      return new FCPFormatErrorMessage(responseBytes);
    }
    if (header.equals(FCPMessage.dataFoundHeader)) {
      return new FCPDataFoundMessage(responseBytes);
    }
    if (header.equals(FCPMessage.dataNotFoundHeader)) {
      return new FCPDataNotFoundMessage(responseBytes);
    }
    if (header.equals(FCPMessage.routeNotFoundHeader)) {
      return new FCPRouteNotFoundMessage(responseBytes);
    }
    if (header.equals(FCPMessage.uriErrorHeader)) {
      return new FCPUriErrorMessage(responseBytes);
    }
    if (header.equals(FCPMessage.restartedHeader)) {
      return new FCPRestartedMessage(responseBytes);
    }
    if (header.equals(FCPMessage.keyCollisionHeader)) {
      return new FCPKeyCollisionMessage(responseBytes);
    }
    if (header.equals(FCPMessage.sizeErrorHeader)) {
      return new FCPSizeErrorMessage(responseBytes);
    }
    FCPLogger.log(new FCPUtils(), "unknown response type: "+header, FCPLogger.ERROR);
    throw new ResponseNotKnownException();
  }

  static String findField(byte[] messageBytes, String fieldName) throws FieldNotFoundException {
    FCPLogger.log(new FCPUtils(), " looking for "+fieldName+" in "+new String(messageBytes), FCPLogger.DEBUG);
    java.io.ByteArrayInputStream inStream = new java.io.ByteArrayInputStream(messageBytes);
    java.io.InputStreamReader reader = new java.io.InputStreamReader(inStream);
    java.io.LineNumberReader lnr = new java.io.LineNumberReader(reader);
    try {
      String zeile = lnr.readLine();
      while (zeile!=null) {
        if (zeile.startsWith(fieldName+"=")) {
          return zeile.substring(zeile.indexOf("=")+1);
        }
        zeile=lnr.readLine();
      }
    }
    catch (java.io.IOException e) {
      throw new FieldNotFoundException();
    }
    throw new FieldNotFoundException();
  }

  private static String getMessageHeader(byte[] messageBytes) throws ResponseNotReadableException {
    java.io.ByteArrayInputStream inStream = new java.io.ByteArrayInputStream(messageBytes, 0, 40);
    java.io.InputStreamReader reader = new java.io.InputStreamReader(inStream);
    java.io.LineNumberReader lnr = new java.io.LineNumberReader(reader);
    String header;
    try {
      header = lnr.readLine();
    }
    catch (java.io.IOException e) { throw new ResponseNotReadableException(); }
    return header;
  }

  static String getClassNameOnly(Object o) {
    String className = o.getClass().getName();
    className = className.substring(className.lastIndexOf(".")+1);
    return className;
  }
}