package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

public class FCPRetryingClientGetConnection extends FCPClientGetConnection {

  private int retryCount;
  private int maxRetries;
  private int htlIncrease;

  public FCPRetryingClientGetConnection(String uri, int htl, int maxRetries, int htlIncrease) {
    super(uri, htl);
    this.maxRetries=maxRetries;
    this.htlIncrease=htlIncrease;
  }

  boolean connect() throws ConnectionUnsuccesfullException {
    boolean success=false;
    while (success==false && this.retryCount<this.maxRetries) {
      success=super.connect();
      if (success) {
        return success;
      }
      this.retryCount++;
      if (this.retryCount>this.maxRetries) {
        break;
      }
      this.htl+=this.htlIncrease;
      FCPLogger.log(this, "requesting "+this.uri+" failed ("+this.retryCount+". of "+this.maxRetries+" attempts)", FCPLogger.WARNING);
    }

    return false;
  }
}