package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

abstract class FCPResponse extends FCPMessage {

  private byte[] responseBytes;

  FCPResponse(String messageHeader, byte[] responseBytes) {
    super(messageHeader);
    this.responseBytes=responseBytes;
  }

  String findValueString(String field) throws FieldNotFoundException {
    return FCPUtils.findField(this.responseBytes, field);
  }

  int findValueHex(String field) throws FieldNotFoundException {
    String string = FCPUtils.findField(this.responseBytes, field);
    return Integer.parseInt(string, 16);
  }

  int findValueInteger(String field) throws FieldNotFoundException {
    String string = FCPUtils.findField(this.responseBytes, field);
    return Integer.parseInt(string);
  }

  String getMessageString() {
    return new String(responseBytes);
  }

  byte[] getMessageBytes() {
    return this.responseBytes;
  }

  abstract String getMessageInfo();
}