package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

abstract class FCPRequest extends FCPMessage {

  FCPRequest(String messageHeader) {
    super(messageHeader);
  }

  void addFieldValuePair(String field, String value) {
    StringBuffer fieldValueBuf = new StringBuffer();
    fieldValueBuf.append(field);
    fieldValueBuf.append("=");
    fieldValueBuf.append(value);
    super.addToFieldValueList(fieldValueBuf.toString());
  }

  String getMessageString() {
    StringBuffer msgBuffer = new StringBuffer();
    msgBuffer.append(super.getMessageHeader());
    msgBuffer.append("\n");
    java.util.Iterator i = super.getFieldValueListIterator();
    while (i.hasNext()) {
      msgBuffer.append(i.next());
      msgBuffer.append("\n");
    }
    msgBuffer.append(super.getEndMessage());
    msgBuffer.append("\n");
    return msgBuffer.toString();
  }

  byte[] getMessageBytes() {
    return this.getMessageString().getBytes();
  }

  abstract String getMessageInfo();
}