package freenetmessageboard.fcpinterface;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class FCPRedirectClientPutConnection extends FCPClientPutConnection {

  FCPClientPutConnection redirectClientPutConnection;

  private String redirectUri;
  private int htl;

  public FCPRedirectClientPutConnection(String uri, int htl, byte[] dataBytes, byte[] metaBytes) {
    super("CHK@", htl, dataBytes, metaBytes);
    this.redirectUri=uri;
    this.htl=htl;
  }

  public boolean connect() throws ConnectionUnsuccesfullException {
    FCPLogger.log(this, "starting redirecting client put connection to "+this.redirectUri, FCPLogger.INTERFACE_NORMAL);
    FCPLogger.log(this, "inserting data to a CHK@...", FCPLogger.INTERFACE_NORMAL);
    boolean chkSuccess = super.connect();
    if (chkSuccess || super.lastResponse instanceof FCPKeyCollisionMessage) {
      String chkUri;
      if (super.lastResponse instanceof FCPSuccessMessage) {
        FCPSuccessMessage msg = (FCPSuccessMessage)super.lastResponse;
        chkUri=msg.getUri();
      } else {
        FCPKeyCollisionMessage msg = (FCPKeyCollisionMessage)super.getLastResponse();
        chkUri = msg.getUri();
      }
      FCPLogger.log(this, "inserting redirect: "+this.redirectUri+" > "+chkUri, FCPLogger.INTERFACE_NORMAL);
      this.redirectClientPutConnection = new FCPClientPutConnection(this.redirectUri, this.htl, new byte[0], FCPFacade.instance().getRedirectMetaBytes(chkUri, "application/zip"));
      boolean success = this.redirectClientPutConnection.connect();
      if (success) {
        FCPLogger.log(this, "the insert to "+this.redirectUri+" was succesful.", FCPLogger.INTERFACE_NORMAL);
      } else {
        FCPLogger.log(this, "the insert to "+this.redirectUri+" failed: ", FCPLogger.INTERFACE_WARNING);
        FCPLogger.log(this, redirectClientPutConnection.lastResponse.getMessageInfo(), FCPLogger.INTERFACE_WARNING);
      }
      this.lastResponse=redirectClientPutConnection.lastResponse;
      return success;
    }
    return false;
  }
}