package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPRedirectClientGetConnection extends FCPClientGetConnection {

  FCPRedirectClientGetConnection(String uri, int htl) {
    super(uri, htl);
  }

  private String getFixedLengthIntString(int i, int digits) {
    StringBuffer buf = new StringBuffer(Integer.toString(i));
    for (int j=buf.length(); j<digits; j++) {
      buf.insert(0,"0");
    }
    return buf.toString();
  }

  private String getDateBasedRedirectionURI(String key, long baseline, long increment) throws UnknownDatedBasedRedirectException {
    java.util.Calendar calendar = new java.util.GregorianCalendar();
    calendar.setTimeZone(java.util.TimeZone.getTimeZone("GMT"));
    StringBuffer buf = new StringBuffer();
    buf.append(key.substring(0, key.indexOf("/")+1));
    FCPLogger.log(this, "beginning of key is "+buf.toString(), FCPLogger.DEBUG);
    buf.append(this.getFixedLengthIntString(calendar.get(java.util.Calendar.YEAR), 4));
    buf.append(this.getFixedLengthIntString(calendar.get(java.util.Calendar.MONTH)+1, 2));
    buf.append(this.getFixedLengthIntString(calendar.get(java.util.Calendar.DAY_OF_MONTH), 2));
    FCPLogger.log(this, "...with date:"+buf.toString(), FCPLogger.DEBUG);
    if (increment!=86400) {
      throw new UnknownDatedBasedRedirectException();
    }
    buf.append("000000-");
    FCPLogger.log(this, "...with seconds:"+buf.toString(), FCPLogger.DEBUG);
    buf.append(key.substring(key.indexOf("/")+1));
    FCPLogger.log(this, "complete:"+buf.toString(), FCPLogger.DEBUG);
    return buf.toString();
  }

  boolean connect() throws ConnectionUnsuccesfullException {
    try {
      boolean finalDataFound=false;
      while (finalDataFound==false) {
        boolean success=super.connect();

        if (success==false) {
          return false;
        }
        FCPLogger.log(this, "received: "+super.uri , FCPLogger.INFO);
        if (super.getMetaData()==null) {
          return true;
        }
     /*   if (new String(super.getData()).indexOf("RedirectTarget")<0) {
          return true;
        }*/
        java.io.LineNumberReader lnr = new java.io.LineNumberReader(new java.io.StringReader(new String(super.getMetaData())));
        finalDataFound=true;
        while(true) {
          String line = lnr.readLine();
          if (line==null) break;
          FCPLogger.log(this, "metadata line: "+line, FCPLogger.INFO);
          if (line.startsWith("Redirect.Target=")) {
            String newKey = line.substring(line.indexOf("=")+1);
            FCPLogger.log(this, "following redirect to "+newKey, FCPLogger.NORMAL);
            if (super.uri.equals(newKey)) {
              continue;
            }
            super.uri=newKey;
            finalDataFound=false;
            break;
          }
        }
 /*       FCPLogger.log(this, "parsing redirection in key "+this.uri, FCPLogger.INFO);
        line = lnr.readLine();
        boolean dateBased=false;
        String incrementString= new String();
        String baselineString=new String();
        while (true) {
          FCPLogger.log(this, "metadata line: "+line, FCPLogger.INFO);
          if (line.equalsIgnoreCase("End")) {
            break;
          }
          if (line.toLowerCase().startsWith("increment=")) {
            dateBased=true;
            incrementString = line.substring(line.lastIndexOf("=")+1);
          }
          if (line.toLowerCase().startsWith("baseline=")) {
            dateBased=true;
            baselineString = line.substring(line.lastIndexOf("=")+1);
          }
          line = lnr.readLine();
        }
        String newKey = lnr.readLine();
        if (dateBased) {
        //  FCPLogger.log(this, "datebased redirection found", FCPLogger.INFO);
          long increment = Long.parseLong(incrementString);
          long baseline = Long.parseLong(baselineString);
          newKey = this.getDateBasedRedirectionURI(newKey, baseline, increment);
          FCPLogger.log(this, "following redirection to "+newKey, FCPLogger.NORMAL);
          super.uri=newKey;
        } else {
          FCPLogger.log(this, "following redirection to "+newKey, FCPLogger.NORMAL);
          super.uri=newKey;
        } */
      }
      return true;
    }
    catch (ConnectionUnsuccesfullException e) {
      throw e;
    }
    catch (FCPException e) {
      FCPLogger.log(this, FCPUtils.getClassNameOnly(e)+" occured while checking redirects "+this.uri+":"+e.getMessage(), FCPLogger.WARNING);
      throw new ConnectionUnsuccesfullException(e);
    }
     catch (java.io.IOException e) {
      FCPLogger.log(this, FCPUtils.getClassNameOnly(e)+" while checking for redirects: "+e.getMessage(), FCPLogger.ERROR);
      throw new ConnectionUnsuccesfullException(e);
    }
  }
}