package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

public class FCPPendingMessage extends FCPResponse {

  private String uri;
  private String privateKey;
  private String publicKey;

  FCPPendingMessage(byte[] responseBytes) {
    super(FCPMessage.successHeader, responseBytes);
    try {
      this.uri=super.findValueString("URI");
    } catch (FieldNotFoundException e) { };
    try {
      this.privateKey=super.findValueString("PrivateKey");
    } catch (FieldNotFoundException e) { };
    try {
      this.publicKey=super.findValueString("PublicKey");
    } catch (FieldNotFoundException e) { };
  }

  String getPrivateKey() {
    return this.privateKey;
  }

  String getPublicKey() {
    if (FCPConfig.isFreenet0_4()) {
      return this.publicKey+"PAgM";
    } else {
      return this.publicKey+"QAgE";
    }
  }

  String getUri() {
    return this.uri;
  }

  String getMessageInfo() {
    StringBuffer buf = new StringBuffer();
    if (this.uri!=null) buf.append("uri: "+this.uri+" / ");
    if (this.privateKey!=null) buf.append(" keys were generated. ");
    return buf.toString();
  }

}