package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPNodeHelloMessage extends FCPResponse {

  private String protocolVersionNumber;
  private String nodeDescription;

  FCPNodeHelloMessage(byte[] messageBytes) throws BadMessageFormatException {
    super(FCPMessage.nodeHelloMessageHeader, messageBytes);
    try {
      this.protocolVersionNumber=super.findValueString("Protocol");
      this.nodeDescription=super.findValueString("Node");
    } catch (FieldNotFoundException e) {
      throw new BadMessageFormatException();
    }
  }

  String getProtocolVersionNumber() {
    return this.protocolVersionNumber;
  }

  String getNodeDescription() {
    return this.nodeDescription;
  }

  String getMessageInfo() {
    return this.nodeDescription+" running with protocol "+this.protocolVersionNumber;
  }
}