package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

abstract class FCPMessage {

  private String messageHeader;
  protected String endMessage = FCPMessage.endMessageString;
  private java.util.List fieldValueList = new java.util.ArrayList();
  static String clientHelloMessageHeader = "ClientHello";
  static String nodeHelloMessageHeader = "NodeHello";
  static String generateSVKKeyPairHeader = "GenerateSVKPair";
  static String successHeader = "Success";
  static String clientGetHeader = "ClientGet";
  static String failedHeader = "Failed";
  static String formatErrorHeader = "FormatError";
  static String dataFoundHeader = "DataFound";
  static String uriErrorHeader = "URIError";
  static String sizeErrorHeader ="SizeError";
  static String pendingHeader = "Pending";
  static String keyCollisionHeader = "KeyCollision";
  static String dataNotFoundHeader = "DataNotFound";
  static String restartedHeader = "Restarted";
  static String clientPutHeader = "ClientPut";
  static String routeNotFoundHeader = "RouteNotFound";
  static String sizeErrorHedaer = "SizeError";
  static String dataChunkHeader = "DataChunk";
  static String endMessageString = "EndMessage";


  FCPMessage(final String messageHeader) {
    this.messageHeader=messageHeader;
  }

  protected String getMessageHeader() {
    return this.messageHeader;
  }

  protected String getEndMessage() {
    return this.endMessage;
  }

  protected void addToFieldValueList(String string) {
    this.fieldValueList.add(string);
  }

  protected java.util.Iterator getFieldValueListIterator() {
    return this.fieldValueList.iterator();
  }

  String getValue(String field) throws FieldNotFoundException {
    java.util.Iterator i = this.fieldValueList.iterator();
    while (i.hasNext()) {
      String fieldValueString = (String)i.next();
      if (fieldValueString.startsWith(field+"=")) {
        return fieldValueString.substring(fieldValueString.indexOf("=")+1);
      }
    }
    throw new FieldNotFoundException();
  }

  abstract String getMessageString();

  abstract String getMessageInfo();

}