package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPMSKRedirectClientGetConnection extends FCPRedirectClientGetConnection {

  private String mapFileUri;
  private String relativeUri;

  FCPMSKRedirectClientGetConnection(String uri, int htl) {
    super(uri, htl);
  }

  String getRelativeUri() {
    return this.relativeUri;
  }

  String getMapFileUri() {
    return this.mapFileUri;
  }

  boolean connect() throws ConnectionUnsuccesfullException {
    try {
      if (super.uri.toUpperCase().startsWith("MSK@")==false) {
        return super.connect();
      }
      try {
        this.mapFileUri = this.uri.substring(this.uri.indexOf("@")+1, this.uri.lastIndexOf("//"));
        this.relativeUri = this.uri.substring(this.uri.lastIndexOf("//")+2);
      } catch (StringIndexOutOfBoundsException e) {
       FCPLogger.log(this, "the uri "+super.uri+" has wrong format (doesn't contain \"//\")", FCPLogger.WARNING);
        throw new ConnectionUnsuccesfullException(new BadMSKKeyException());
      }
      FCPLogger.log(this, "retrieving msk-mapfile from "+this.mapFileUri+" first...", FCPLogger.INFO);
      this.uri=this.mapFileUri;
      boolean success = super.connect();
      if (success==false) {
        FCPLogger.log(this, "could not read msk-map file "+this.mapFileUri+"...", FCPLogger.WARNING);
        return false;
      }
      if (super.getMetaData()==null) {
        FCPLogger.log(this, "the mapfile "+this.mapFileUri+" contained no metadata", FCPLogger.WARNING);
        throw new ConnectionUnsuccesfullException(new InvalidMapFileException());
      }
      java.io.StringReader stringReader = new java.io.StringReader(new String(super.getMetaData()));
      java.io.LineNumberReader lnr = new java.io.LineNumberReader(stringReader);
      FCPLogger.log(this, "parsing the msk-map-file from key"+this.mapFileUri+"...", FCPLogger.DEBUG);
      String header = lnr.readLine();
      if (header.equalsIgnoreCase("Mapfile")==false) {
        FCPLogger.log(this, "the mapfile "+this.mapFileUri+" contained a wrong header: "+header, FCPLogger.WARNING);
        throw new ConnectionUnsuccesfullException(new InvalidMapFileException());
      }
      FCPLogger.log(this, "the map-file header was ok.", FCPLogger.DEBUG);
      String defaultIndexString = lnr.readLine();
      String defaultIndexFile = defaultIndexString.substring(defaultIndexString.indexOf("=")+1);
      FCPLogger.log(this, "the default index file is "+defaultIndexFile, FCPLogger.DEBUG);
      if (this.relativeUri.length()==0) {
        this.relativeUri=defaultIndexFile;
      }
      String end = lnr.readLine();
      if (end.equalsIgnoreCase("End")==false) {
        FCPLogger.log(this, "the mapfile "+this.mapFileUri+" contained a wrong end statement: "+end, FCPLogger.WARNING);
        throw new ConnectionUnsuccesfullException(new InvalidMapFileException());
      }
      FCPLogger.log(this, "the end statement was found "+defaultIndexFile, FCPLogger.DEBUG);
      FCPLogger.log(this, "looking for "+this.relativeUri+" in the msk-map-file "+this.mapFileUri+"...", FCPLogger.INFO);

      while (true) {
        String line = lnr.readLine();
        if (line==null) {
          break;
        }
        if (line.startsWith(this.relativeUri+"=")) {
           super.uri=line.substring(line.indexOf("=")+1);
           FCPLogger.log(this, "found redirect to "+super.uri+" in the mapfile", FCPLogger.NORMAL);
           return super.connect();
        }
      }
      FCPLogger.log(this, "the key "+this.relativeUri+" was not found in the mapfile "+this.mapFileUri, FCPLogger.WARNING);
      throw new ConnectionUnsuccesfullException(new FileNotFoundInMSKException());
    }
    catch (java.io.IOException e) {
      throw new ConnectionUnsuccesfullException(e);
    }
  }
}