package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPIndexIncreasingClientPutConnection extends FCPClientPutConnection {

  private String commonUriPart;
  private int index;
  private char indexDelim;

  FCPIndexIncreasingClientPutConnection(String uri, int htl, byte[] dataBytes, byte[] metaBytes, char indexDelim) {
    super(uri, htl, dataBytes, metaBytes);
    this.indexDelim=indexDelim;
  }

  boolean connect() throws ConnectionUnsuccesfullException  {
    try {
      FCPLogger.log(this, "original uri "+super.uri, FCPLogger.INFO);
      this.commonUriPart=super.uri.substring(0, super.uri.lastIndexOf(this.indexDelim)+1);
      FCPLogger.log(this, "commmon uri "+ this.commonUriPart, FCPLogger.INFO);
      if (this.indexDelim=='/') {
        this.index = Integer.parseInt(super.uri.substring(super.uri.lastIndexOf(this.indexDelim)+1));
      } else {
        String indexString = super.uri.substring(super.uri.lastIndexOf(this.indexDelim)+1, super.uri.length()-4);
        FCPLogger.log(this, "index "+ indexString, FCPLogger.INFO);
        this.index = Integer.parseInt(indexString);
      }

    } catch (Exception e) {
      throw new ConnectionUnsuccesfullException(new UriFormatErrorException());
    }
    boolean success=super.connect();
    while(success==false) {
      if (super.lastResponse instanceof FCPKeyCollisionMessage) {
        this.index++;
        if (this.indexDelim=='/') {
          super.uri=this.commonUriPart+Integer.toString(this.index);
        } else {
           super.uri=this.commonUriPart+Integer.toString(this.index)+".txt";
        }

        FCPLogger.log(this, "key collision detected! increasing index: "+super.uri, FCPLogger.WARNING);
        success=super.connect();
      } else {
        return false;
      }
    }
    return true;
  }

}