package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPGenerateSVKPairConnection extends FCPConnection {

  private String privateKey;
  private String publicKey;

  FCPGenerateSVKPairConnection () {
    super();
  }

  boolean connect() throws ConnectionUnsuccesfullException {
    try {
      super.connect();
      FCPLogger.log(this, "asking fred to generate a new keypair for us", FCPLogger.NORMAL);
      this.sendToNode(new FCPGenerateSVKPairMessage());
      this.lastResponse = this.receiveFromNode();
      if (this.lastResponse instanceof FCPSuccessMessage) {
        this.privateKey=((FCPSuccessMessage)this.lastResponse).getPrivateKey();
        this.publicKey=((FCPSuccessMessage)this.lastResponse).getPublicKey();
        FCPLogger.log(this, "great. now we have a new generated public key: "+this.publicKey, FCPLogger.NORMAL);
        this.wasSuccesfull=true;
        return true;
      } else {
        this.wasSuccesfull=false;
        FCPLogger.log(this, "the key generation failed: "+this.lastResponse.getMessageInfo(), FCPLogger.ERROR);
        return false;
      }
    }
    catch (ConnectionUnsuccesfullException e) {
      throw e;
    }
    catch (FCPException e) {
      FCPLogger.log(this, "exception during key generation: "+FCPUtils.getClassNameOnly(e)+": "+e.getMessage(), FCPLogger.WARNING);
      throw new ConnectionUnsuccesfullException(e);
    }
    catch (InterruptedException e) {
      FCPLogger.log(this, "thread "+Thread.currentThread().getName()+" was interrupted!", FCPLogger.WARNING);
      throw new ConnectionUnsuccesfullException(e);
    }
  }

  String getPublicKey() {
    return this.publicKey;
  }

  String getPrivateKey() {
    return this.privateKey;
  }

}