package freenetmessageboard.fcpinterface;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class FCPFacade extends Thread {

  private static FCPFacade instance;

  private java.util.HashMap insertCallbacksMap = new java.util.HashMap();
  private java.util.HashMap insertOriginalUriMap = new java.util.HashMap();
  private java.util.HashMap requestCallbacksMap = new java.util.HashMap();
  private java.util.HashMap requestOriginalUriMap = new java.util.HashMap();
  private java.util.List queuedInsertThreads = new java.util.LinkedList();
  private java.util.List queuedRequestThreads = new java.util.LinkedList();
  private java.util.List activeInsertThreads = new java.util.LinkedList();
  private java.util.List activeRequestThreads = new java.util.LinkedList();

  private int maxSimultaneousInserts = 5;
  private int maxSimultaneousRequests = 5;

  private FCPFacade() {
    this.setName("FCPInterface");
  }

  public KeyPair generateKeyPair() throws FailedToConnectToNodeException {
    try {
      FCPLogger.log(this, "generating a new key pair...", FCPLogger.INTERFACE_NORMAL);
      FCPGenerateSVKPairConnection keyPairConnection = new FCPGenerateSVKPairConnection();
      FCPConnectionThread generateKeyThread = new FCPConnectionThread(keyPairConnection);
      generateKeyThread.start();
      while(generateKeyThread.isFinished()==false) {
        try {
          Thread.sleep(20);
        }
        catch (InterruptedException ex) {
        }
      }
      if (keyPairConnection.getPrivateKey()==null) {
        throw new FailedToConnectToNodeException(generateKeyThread.getException().originalException.getMessage());
      }
      return new KeyPair(keyPairConnection.getPublicKey(), keyPairConnection.getPrivateKey());
    } catch (java.lang.Exception ex) {
      throw new FailedToConnectToNodeException("failed to generate key pair: "+ex.getMessage());
    }
  }

  public void startFreenetRequest(FCPRequestCallback callback, String uri, int htl, boolean followRedirects) {
    FCPLogger.log(this, "received freenet request for key "+uri+" with "+htl+" htl", FCPLogger.NORMAL);
    FCPClientGetConnection clientGetConnection;
    if (followRedirects) {
      clientGetConnection= new FCPRedirectClientGetConnection(uri, htl);
    } else {
      clientGetConnection= new FCPClientGetConnection(uri, htl);
    }
    FCPConnectionThread connectionThread = new FCPConnectionThread(clientGetConnection);
    this.requestCallbacksMap.put(connectionThread, callback);
    this.requestOriginalUriMap.put(connectionThread, uri);
    this.queueRequest(connectionThread);
  }

  private void queueRequest(FCPConnectionThread thread) {
    synchronized (this.queuedRequestThreads) {
      this.queuedRequestThreads.add(thread);
    }
  }

  public byte[] getContentTypeMetaBytes(String contentType) {
   StringBuffer buf = new StringBuffer();
    buf.append("Version\n");
    buf.append("Revision=1\n");
    buf.append("EndPart\n");
    buf.append("Document\n");
    buf.append("Info.Format=");
    buf.append(contentType);
    buf.append("\nInfo.Description=file\n");
    buf.append("End\n");
    return buf.toString().getBytes();
  }

  byte[] getRedirectMetaBytes(String redirectUri, String contentType) {
    StringBuffer buf = new StringBuffer();
    buf.append("Version\n");
    buf.append("Revision=1\n");
    buf.append("EndPart\n");
    buf.append("Document\n");
    buf.append("Redirect.Target=");
    buf.append(redirectUri);
    buf.append("\nEnd\n");
    buf.append("Info.Format=");
    buf.append(contentType);
    buf.append("\nInfo.Description=file\n");
    buf.append("End\n");
    return buf.toString().getBytes();
  }

  private synchronized void startQueuedRequests() {
    FCPLogger.log(this, "starting queued requests...", FCPLogger.INFO);
    java.util.List threadsToRemoveFromQueue = new java.util.LinkedList();
    synchronized (this.queuedRequestThreads) {
      java.util.Collections.sort(this.queuedRequestThreads, FCPConnectionThread.getPriorityComparator());
      java.util.Iterator it = this.queuedRequestThreads.iterator();
      while(it.hasNext() && this.activeRequestThreads.size()<this.maxSimultaneousRequests) {
        FCPConnectionThread thread = (FCPConnectionThread)it.next();
        FCPLogger.log(this, "starting thread "+thread.getName()+" which was queued.", FCPLogger.NORMAL);
        thread.start();
        FCPRequestCallback callback = (FCPRequestCallback)this.requestCallbacksMap.get(thread);
        callback.requestStarted((String)this.requestOriginalUriMap.get(thread));
        this.activeRequestThreads.add(thread);
        threadsToRemoveFromQueue.add(thread);
        break;
      }
      it = threadsToRemoveFromQueue.iterator();
      while(it.hasNext()) {
        this.queuedRequestThreads.remove(it.next());
      }
    }
  }

   public void startFreenetInsert(FCPInsertCallback callback, String uri, byte[] metaBytes, byte[] dataBytes, int htl, boolean redirect) {
    FCPLogger.log(this, "received freenet insert of key "+uri+" with "+htl+" htl", FCPLogger.NORMAL);
    FCPClientPutConnection clientPutConnection;
    if (redirect==false) {
      clientPutConnection= new FCPClientPutConnection(uri, htl, dataBytes, metaBytes);
    } else {
      clientPutConnection= new FCPRedirectClientPutConnection(uri, htl, dataBytes, metaBytes);
    }
    FCPConnectionThread connectionThread = new FCPConnectionThread(clientPutConnection);
    this.insertCallbacksMap.put(connectionThread, callback);
    this.insertOriginalUriMap.put(connectionThread, uri);
    FCPLogger.log(this, "trying to queue insert to "+uri, FCPLogger.INFO);
    this.queueInsert(connectionThread);
    FCPLogger.log(this, "returned from queueInsert", FCPLogger.INFO);
  }

  private void queueInsert(FCPConnectionThread thread) {
    synchronized(this.queuedInsertThreads) {
      this.queuedInsertThreads.add(thread);
    }
  }

  private synchronized void startQueuedInserts() {
    FCPLogger.log(this, "starting queued inserts...", FCPLogger.INFO);
    java.util.List threadsToRemoveFromQueue = new java.util.LinkedList();
    synchronized(this.queuedInsertThreads) {
      java.util.Collections.sort(this.queuedInsertThreads, FCPConnectionThread.getPriorityComparator());
      java.util.Iterator it = this.queuedInsertThreads.iterator();
      while(it.hasNext() && this.activeInsertThreads.size()<this.maxSimultaneousInserts) {
        FCPConnectionThread thread = (FCPConnectionThread)it.next();
        FCPLogger.log(this, "starting thread "+thread.getName()+" which was queued. ", FCPLogger.NORMAL);
        thread.start();
        this.activeInsertThreads.add(thread);
        threadsToRemoveFromQueue.add(thread);
        break;
      }
      it = threadsToRemoveFromQueue.iterator();
      while(it.hasNext()) {
        this.queuedInsertThreads.remove(it.next());
      }
    }
    FCPLogger.log(this, activeInsertThreads.size()+" active inserts, "+this.queuedInsertThreads.size()+" inserts left in queue...", FCPLogger.INFO);
  }


  public static synchronized FCPFacade instance() {
    if (FCPFacade.instance==null) {
      FCPFacade.instance=new FCPFacade();
      FCPFacade.instance.start();
    }
    return FCPFacade.instance;
  }

  private synchronized void checkForFinishedRequests() {
    FCPLogger.log(this, "ckecking for finished requests...", FCPLogger.INFO);
    java.util.Iterator it = this.activeRequestThreads.iterator();
    java.util.List finishedThreads = new java.util.LinkedList();
    while(it.hasNext()) {
      FCPConnectionThread thread = (FCPConnectionThread)it.next();
      if (thread.isFinished()) {
        finishedThreads.add(thread);
        FCPRequestCallback callback = (FCPRequestCallback)this.requestCallbacksMap.get(thread);
        String origUri = (String)this.requestOriginalUriMap.get(thread);
        if (thread.wasSuccesfull()) {
          if (thread.getConnection() instanceof FCPClientGetConnection) {
            FCPClientGetConnection clientGetConnection = (FCPClientGetConnection)thread.getConnection();
            FCPLogger.log(this, "the thread requesting "+origUri+" succeeded.", FCPLogger.NORMAL);
            RequestedData requestedData = new RequestedData(origUri, clientGetConnection);
            callback.requestSuccesfull(origUri, requestedData);
          }
        } else {
          if (thread.getConnection() instanceof FCPClientGetConnection) {
           FCPClientGetConnection clientGetConnection = (FCPClientGetConnection)thread.getConnection();

            if (thread.getException()!=null) {
              FCPLogger.log(this, "the thread requesting "+origUri+" caught an Exception: ", FCPLogger.INTERFACE_WARNING);
              callback.requestFailedBadly(origUri, thread.getException().originalException.getClass().getName());
              continue;
            }
             FCPResponse lastResponse = clientGetConnection.getLastResponse();

            if (lastResponse instanceof FCPDataNotFoundMessage) {
              FCPLogger.log(this, "the thread requesting "+origUri+" failed with htl "+clientGetConnection.getHtl()+": "+lastResponse.getMessageInfo(), FCPLogger.INTERFACE_NORMAL);
              callback.requestFailedWithDataNotFound(origUri);
              continue;
            }
            if (lastResponse instanceof FCPRouteNotFoundMessage) {
              FCPLogger.log(this, "the thread requesting "+origUri+" failed with htl "+clientGetConnection.getHtl()+": "+lastResponse.getMessageInfo(), FCPLogger.INTERFACE_WARNING);
              callback.requestFailedWithRouteNotFound(origUri);
              continue;
            }
            FCPLogger.log(this, "the thread requesting "+origUri+" failed with htl "+clientGetConnection.getHtl()+": "+lastResponse.getMessageInfo(), FCPLogger.ERROR);
            callback.requestFailedBadly(origUri, lastResponse.getMessageInfo());
          }
        }
      }
    }

    it = finishedThreads.iterator();
    while (it.hasNext()) {
      FCPConnectionThread thread = (FCPConnectionThread)it.next();
      this.activeRequestThreads.remove(thread);
      this.requestCallbacksMap.remove(thread);
      this.requestOriginalUriMap.remove(thread);
    }
  }

  private synchronized void checkForFinishedInserts() {
    FCPLogger.log(this, "ckecking for finished inserts...", FCPLogger.INFO);
    java.util.Iterator it = this.activeInsertThreads.iterator();
    java.util.List finishedThreads = new java.util.LinkedList();
    while(it.hasNext()) {
      FCPConnectionThread thread = (FCPConnectionThread)it.next();
      if (thread.isFinished()) {
        finishedThreads.add(thread);
        FCPInsertCallback callback = (FCPInsertCallback)this.insertCallbacksMap.get(thread);
        String origUri = (String)this.insertOriginalUriMap.get(thread);
        if (thread.wasSuccesfull()) {
          if (thread.getConnection() instanceof FCPClientPutConnection) {
            FCPClientPutConnection clientPutConnection = (FCPClientPutConnection)thread.getConnection();
            FCPLogger.log(this, "the thread inserting "+origUri+" succeeded.", FCPLogger.NORMAL);
            InsertInfo insertInfo = new InsertInfo(origUri, clientPutConnection, 1);
            callback.insertSuccesfull(origUri, insertInfo);
          }
        } else {
          if (thread.getConnection() instanceof FCPClientPutConnection) {
            FCPClientPutConnection clientPutConnection = (FCPClientPutConnection)thread.getConnection();
            if (thread.getException()!=null) {
              FCPLogger.log(this, "the thread inserting "+origUri+" caught an Exception: ", FCPLogger.INTERFACE_WARNING);
              callback.insertFailedBadly(origUri, thread.getException().originalException.getClass().getName());
              continue;
            }
            FCPResponse lastResponse = clientPutConnection.getLastResponse();
            if (lastResponse instanceof FCPKeyCollisionMessage) {
              FCPLogger.log(this, "the thread inserting "+origUri+" had a key collision: "+lastResponse.getMessageInfo(), FCPLogger.INTERFACE_NORMAL);
              FCPLogger.log(this, "trying to call the callback method...", FCPLogger.INFO);
              callback.insertFailedWithKeyCollision(origUri);
              FCPLogger.log(this, "returned from callback method.", FCPLogger.INFO);
              continue;
            }
            FCPLogger.log(this, "the thread inserting "+origUri+" failed: "+lastResponse.getMessageInfo(), FCPLogger.INTERFACE_WARNING);

            if (lastResponse instanceof FCPRouteNotFoundMessage) {
              callback.insertFailedWithRouteNotFound(origUri);
              continue;
            }
            callback.insertFailedBadly(origUri, lastResponse.getMessageInfo());
          }
        }
      }
    }

    it = finishedThreads.iterator();
    while (it.hasNext()) {
      FCPConnectionThread thread = (FCPConnectionThread)it.next();
      this.activeInsertThreads.remove(thread);
      this.insertCallbacksMap.remove(thread);
      this.insertOriginalUriMap.remove(thread);
    }
  }

  public void run() {
    FCPLogger.log(this, "the FCPFacade is starting up...", FCPLogger.NORMAL);
    while(true) {
      this.checkForFinishedRequests();
      this.startQueuedRequests();
      this.checkForFinishedInserts();
      this.startQueuedInserts();
      try {
        Thread.sleep(100);
      }
      catch (InterruptedException ex) {
      }

    }
  }
}
