package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPException extends Exception { }

class FCPDuplicateKeyException extends FCPException { }

class FieldNotFoundException extends FCPException { }

class ResponseNotReadableException extends FCPException { }

class ResponseNotKnownException extends FCPException { }

class BadMessageFormatException extends FCPException { }

class BadMSKKeyException extends FCPException { }

class InvalidMapFileException extends FCPException { }

class UriFormatErrorException extends FCPException { }

class CannotCreateSocketException extends FCPException {
  public String getMessage() {
    return "failed to create socket to the freenet node";
  }

}

class SocketClosedDownException extends FCPException { }

class FileNotFoundInMSKException extends FCPException { }

class WrongDataLengthException extends FCPException {}

class TransferRestartedException extends FCPException { }

class UnknownDatedBasedRedirectException extends FCPException { }

class CannotConnectToNodeException extends ConnectionUnsuccesfullException {
  CannotConnectToNodeException(Exception e) {
    super(e);
  }
}


class ConnectionUnsuccesfullException extends FCPException {
  Exception originalException;
  ConnectionUnsuccesfullException(Exception e) {
    this.originalException=e;
  }
}
