package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPDataFoundMessage extends FCPResponse {

  private int dataLength;
  private int metaDataLength=0;

  FCPDataFoundMessage(byte[] responseBytes) {
    super(FCPMessage.dataFoundHeader, responseBytes);
    try {
      this.dataLength = super.findValueHex("DataLength");
      this.metaDataLength=super.findValueHex("MetadataLength");
      this.dataLength-=this.metaDataLength;
    } catch (FieldNotFoundException e) { }
  }
  String getMessageInfo() {
    if (this.metaDataLength==0) {
      return "the requested key has "+dataLength+" bytes of data";
    } else {
      return "the requested key has "+dataLength+" bytes of data and "+this.metaDataLength+" bytes of metadata";
    }
  }

  int getDataLength() {
    return this.dataLength;
  }

  int getMetaDataLength() {
    return this.metaDataLength;
  }
}