package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPConnectionThread extends Thread {

  private FCPConnection connection;
  private boolean running;
  private boolean wasSuccesfull;
  private boolean finished;
  private ConnectionUnsuccesfullException exception;
  private FCPResponse lastResponse;
  private long startTime;
  private long endTime;

  private int priority=FCPConnectionThread.PRIORITY_NORMAL;

  final static int PRIORITY_VERY_HIGH=5;
  final static int PRIORITY_HIGH=4;
  final static int PRIORITY_NORMAL=3;
  final static int PRIORITY_LOW=2;
  final static int PRIORITY_VERY_LOW=1;

  FCPConnectionThread(FCPConnection connection) {
    FCPLogger.log(this, "Thread created for "+FCPUtils.getClassNameOnly(connection), FCPLogger.INFO);
    this.connection=connection;
    this.setName("FCP-Connection-"+this.getName());
  }

  void setPriorityHigh() {
    this.priority=FCPConnectionThread.PRIORITY_HIGH;
  }

  void setPriorityLow() {
    this.priority=FCPConnectionThread.PRIORITY_LOW;
  }

  static java.util.Comparator getPriorityComparator() {
    return new java.util.Comparator() {
      public int compare(Object o1, Object o2) {
        FCPConnectionThread thread1 = (FCPConnectionThread)o1;
        FCPConnectionThread thread2 = (FCPConnectionThread)o2;
        return new Integer(thread1.priority).compareTo(new Integer(thread2.priority));
      }
    };
  }

  void setPriorityVeryHigh() {
    this.priority=FCPConnectionThread.PRIORITY_VERY_HIGH;
  }

  void setPriorityVeryLow() {
    this.priority=FCPConnectionThread.PRIORITY_VERY_LOW;
  }

  synchronized boolean isFinished() {
   return this.finished;
  }

  synchronized boolean isRunning() {
    return this.running;
  }

  private synchronized void setFinished() {
    this.finished=true;
  }

  synchronized boolean wasSuccesfull() {
    return this.wasSuccesfull;
  }

  private synchronized void onSuccess() {
    FCPLogger.log(this, "Thread was finished succesfully: "+this.lastResponse.getMessageInfo(), FCPLogger.INFO);
    this.wasSuccesfull=true;
    this.setFinished();
  }

  private synchronized void onFailed() {
    FCPLogger.log(this, "Thread was finished without success: "+this.lastResponse.getMessageInfo(), FCPLogger.WARNING);
    this.setFinished();
  }

  private synchronized void onException() {
    if (this.exception.originalException instanceof FCPException) {
      FCPLogger.log(this, "Thread failed because of an "+FCPUtils.getClassNameOnly(this.exception.originalException)+": "+this.exception.originalException.getMessage(), FCPLogger.WARNING);
      this.exception.originalException.printStackTrace();
    } else {
      FCPLogger.log(this, "Thread crashed because of an unexpected "+FCPUtils.getClassNameOnly(this.exception.originalException)+": "+this.exception.originalException.getMessage(), FCPLogger.ERROR);
      this.exception.originalException.printStackTrace();
    }
    this.setFinished();
  }

  FCPConnection getConnection() {
    return this.connection;
  }

  ConnectionUnsuccesfullException getException() {
    return this.exception;
  }

  public void interrupt() {
    FCPLogger.log(this, "Thread was interrupted, closing socket...", FCPLogger.WARNING);
    super.interrupt();
    this.connection.closeSocket();
  }

  int getConnectionTime() {
    return (int)(this.endTime-this.startTime);
  }

  public void run() {
    this.running=true;
    this.startTime=System.currentTimeMillis();
    FCPLogger.log(this, "Thread was started for a "+FCPUtils.getClassNameOnly(this.connection), FCPLogger.INFO);
    try {
      boolean success = this.connection.connect();
      this.lastResponse = this.connection.getLastResponse();
      this.endTime=System.currentTimeMillis();
      if (success) {
        this.onSuccess();
      } else {
        this.onFailed();
      }
      this.connection.closeSocket();
    }
    catch (ConnectionUnsuccesfullException e) {
      this.endTime=System.currentTimeMillis();
      this.connection.closeSocket();
      this.exception=e;
      this.onException();
    }
    catch (Exception e) {
      this.endTime=System.currentTimeMillis();
      this.connection.closeSocket();
      this.exception=new ConnectionUnsuccesfullException(e);
      this.onException();
    }
    this.running=false;
  }
}