package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPConnection {

  private static byte[] sessionIdentifier = { (byte)0, (byte)0 };
  private static byte[] presentationIdentifier = { (byte)0, (byte)2 };
  private static int receiveBufferSize = 1;
  private String hostName;
  private int port;
  private java.net.Socket socket;
  protected FCPResponse lastResponse;

  protected boolean wasSuccesfull=false;

  FCPConnection() {
    this.hostName=FCPConfig.getHostname();
    this.port=FCPConfig.getPort();
  }

  boolean wasSuccesfull() {
    return this.wasSuccesfull;
  }

  FCPResponse getLastResponse() {
    return this.lastResponse;
  }

  private void sendToNode(byte[] bytes) throws SocketClosedDownException {
    try {
      FCPLogger.log(this, "sending "+bytes.length+" raw bytes to the node", FCPLogger.DEBUG);
      this.socket.getOutputStream().write(bytes);
    } catch (java.io.IOException e) {
      FCPLogger.log(this, "socked was closed down: "+e.getMessage(), FCPLogger.ERROR);
      throw new SocketClosedDownException();
    }
  }

  void sendToNode(FCPRequest request) throws SocketClosedDownException {
    try {
      FCPLogger.log(this, "sending "+FCPUtils.getClassNameOnly(request)+" to the node: "+request.getMessageInfo(), FCPLogger.INFO);
      this.socket.getOutputStream().write(request.getMessageBytes());
    } catch (java.io.IOException e) {
      FCPLogger.log(this, "socked was closed down: "+e.getMessage(), FCPLogger.ERROR);
      throw new SocketClosedDownException();
    }
  }

  FCPDataChunkMessage receiveData() throws SocketClosedDownException, WrongDataLengthException, InterruptedException, TransferRestartedException{
    FCPLogger.log(this, "waiting for a chunk of data..", FCPLogger.INFO);
    try {
      java.io.InputStream inpStream = this.socket.getInputStream();
      java.io.ByteArrayOutputStream byteArrayOutputStream = new java.io.ByteArrayOutputStream();
      FCPByteKeywordWatcher keywordWatcher = new FCPByteKeywordWatcher();
      keywordWatcher.addKeyword(FCPMessage.dataChunkHeader);
      keywordWatcher.addKeyword("Data");
      keywordWatcher.addKeyword("Restarted");
      keywordWatcher.addKeyword("EndMessage");
      do {
        int received = inpStream.read();
        if (received==-1) {
          FCPLogger.log(this, "no data coming in, waiting...", FCPLogger.DEBUG);
          try {
            Thread.sleep(1000);
          }
          catch (java.lang.InterruptedException e) {
            throw new java.lang.InterruptedException();
          }
          continue;
        }
        byte receivedByte = (byte)(received);
        FCPLogger.log(this," raw byte received: "+(char)receivedByte, FCPLogger.DEBUG);
        byteArrayOutputStream.write(receivedByte);
        keywordWatcher.lookForKeywords(receivedByte);
        if (keywordWatcher.wasFound("Restarted") && keywordWatcher.wasFound("EndMessage")) {
          throw new TransferRestartedException();

        }
      } while (keywordWatcher.wasFound("Data")==false || keywordWatcher.wasFound("DataChunk")==false);
      byteArrayOutputStream.flush();
      byte[] responseBytes = byteArrayOutputStream.toByteArray();
      int laenge = Integer.parseInt(FCPUtils.findField(responseBytes, "Length"),16);
      FCPLogger.log(this," receiving a chunk of "+laenge+" bytes", FCPLogger.INFO);
      int dataBytesReceived=0;
      java.io.ByteArrayOutputStream os = new java.io.ByteArrayOutputStream(laenge);
      while(dataBytesReceived<laenge) {
        byte[] dataBytes = new byte[laenge-dataBytesReceived];
        int count = inpStream.read(dataBytes);
        if (count==-1) {
          FCPLogger.log(this," connection is stuck. i wait a second until everything goes smooth again.", FCPLogger.WARNING);
          Thread.sleep(1000);
          continue;
        }
        dataBytesReceived+=count;
        if (count!=dataBytes.length) {
          FCPLogger.log(this," only received "+count+" bytes instead of "+dataBytes.length+" but i keep trying...", FCPLogger.INFO);
          os.write(dataBytes, 0, count);
          continue;
        }
        os.write(dataBytes);
      }
      os.flush();
      byte[] dataBytes = os.toByteArray();
      FCPLogger.log(this," received "+dataBytesReceived+" bytes of pure data", FCPLogger.INFO);
      return new FCPDataChunkMessage(responseBytes, dataBytes);
    } catch (java.io.IOException e) {
      throw new SocketClosedDownException();
    }
    catch (FieldNotFoundException e) {
      throw new WrongDataLengthException();
    }
  }

  FCPResponse receiveFromNode() throws SocketClosedDownException, ResponseNotReadableException, ResponseNotKnownException, BadMessageFormatException, InterruptedException {
    try {
      FCPLogger.log(this, "waiting for the response from the node...", FCPLogger.INFO);
      java.io.InputStream inpStream = this.socket.getInputStream();
      java.io.ByteArrayOutputStream byteArrayOutputStream = new java.io.ByteArrayOutputStream();
      byte[] receivedBytes = new byte[FCPConnection.receiveBufferSize];
      FCPByteKeywordWatcher keywordWatcher = new FCPByteKeywordWatcher();
      keywordWatcher.addKeyword(FCPMessage.endMessageString);
      byte receivedByte;
      int received;

      do {
        received = inpStream.read();
        if (received==-1) {
          FCPLogger.log(this, "no data coming in, waiting...", FCPLogger.DEBUG);
          try {
            Thread.sleep(1000);
          }
          catch (java.lang.InterruptedException e) {
            throw new java.lang.InterruptedException();
          }
          continue;
        }
        receivedByte = (byte)(received);
        FCPLogger.log(this, "1 raw byte received: "+(char)receivedByte, FCPLogger.DEBUG);
        byteArrayOutputStream.write(receivedByte);
        keywordWatcher.lookForKeywords(receivedByte);
      } while(keywordWatcher.wasFound(FCPMessage.endMessageString)==false);
      byteArrayOutputStream.flush();
      byte[] byteArray = byteArrayOutputStream.toByteArray();;
      FCPLogger.log(this, byteArray.length+" bytes received.", FCPLogger.DEBUG);
      FCPResponse response = FCPUtils.parseResponse(byteArray);
      FCPLogger.log(this, FCPUtils.getClassNameOnly(response)+" received from node: "+response.getMessageInfo(), FCPLogger.INFO);
      return response;
    } catch (java.io.IOException e) {
      FCPLogger.log(this, "socked was closed down: "+e.getMessage(), FCPLogger.ERROR);
      throw new SocketClosedDownException();
    }
  }

  void closeSocket() {
   if (this.socket==null) {
     return;
   }
   FCPLogger.log(this, "trying to close socket...", FCPLogger.INFO);
    try {
      this.socket.close();
    } catch (java.io.IOException e) {
      FCPLogger.log(this, "cannot close socket! "+e.getMessage(), FCPLogger.ERROR);
    }
    FCPLogger.log(this, "...socket closed", FCPLogger.INFO);

  }

  boolean connect() throws ConnectionUnsuccesfullException {
    try {
      boolean socketCreated=false;
      int socketCreatingTries=0;
      while (socketCreated==false && socketCreatingTries<3) {
        FCPLogger.log(this, "creating fcp connection to "+hostName+":"+port, FCPLogger.INFO);
        try {
          this.socket=new java.net.Socket(hostName, port);
          socketCreated=true;
        }
        catch (java.io.IOException ex) {
          socketCreatingTries++;
          int millis = (int)(Math.random()*400)+200;
          FCPLogger.log(this, "can't create socket, waiting "+millis+" ms before next retry", FCPLogger.WARNING);
          try {
            Thread.sleep(millis);
          }
          catch (InterruptedException exc) {
          }
        }
      }
      if (socketCreated==false) {
        throw new java.io.IOException("cannot create socket to "+hostName+":"+port);
      }
      FCPLogger.log(this, "sending session & presentation identifierts", FCPLogger.INFO);
      this.sendToNode(FCPConnection.sessionIdentifier);
      this.sendToNode(FCPConnection.presentationIdentifier);
      return true;
    }
    catch (java.io.IOException e) {
      FCPLogger.log(this, "cannot connect to freenet node at "+this.hostName+":"+this.port+": "+e.getMessage(), FCPLogger.WARNING);
      throw new ConnectionUnsuccesfullException(new CannotCreateSocketException());
    }
    catch (SocketClosedDownException e) {
      FCPLogger.log(this, "socked was closed down: "+e.getMessage(), FCPLogger.ERROR);
      throw new ConnectionUnsuccesfullException(e);
    }
  }

}