package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPClientPutMessage extends FCPRequest {

  private String uri;
  private int htl;
  private byte[] metaBytes;
  private byte[] dataBytes;

  FCPClientPutMessage(String uri, int htl, byte[] metaBytes, byte[] dataBytes) {
    super(FCPMessage.clientPutHeader);
    this.uri=uri;
    this.htl=htl;
    this.metaBytes=metaBytes;
    this.dataBytes=dataBytes;
    super.endMessage="Data";
    super.addFieldValuePair("HopsToLive", Integer.toString(this.htl));
    super.addFieldValuePair("URI", this.uri) ;

    if (this.metaBytes!=null) {
      super.addFieldValuePair("DataLength", Integer.toString(this.dataBytes.length+this.metaBytes.length,16));
      super.addFieldValuePair("MetadataLength", Integer.toString(this.metaBytes.length,16));
    } else {
      super.addFieldValuePair("DataLength", Integer.toString(this.dataBytes.length,16));
    }
  }

  byte[] getMessageBytes() {
    java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
    byte[] messageHeader = super.getMessageBytes();
    try {
      baos.write(messageHeader);
      FCPLogger.log(this, "header-length "+messageHeader.length, FCPLogger.DEBUG);
      baos.write(this.metaBytes);
      FCPLogger.log(this, "meta-length "+this.metaBytes.length, FCPLogger.DEBUG);
      baos.write(this.dataBytes);
      FCPLogger.log(this, "data-length "+this.dataBytes.length, FCPLogger.DEBUG);
   //   baos.write("012345".getBytes());
      baos.flush();
      byte[] allBytes = baos.toByteArray();
      FCPLogger.log(this, "total length  "+allBytes.length, FCPLogger.DEBUG);
      FCPLogger.log(this, new String(allBytes), FCPLogger.DEBUG);
      return allBytes;
    } catch (java.io.IOException e) {
      FCPLogger.log(this, "IOException while creating the bytearray for the put message. sorry this error is critical! ", FCPLogger.ERROR);
      return new byte[7];
    }
  }


  String getMessageInfo() {
    return "trying to insert key "+this.uri+" with htl "+this.htl;
  }
}