package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPClientPutConnection extends FCPConnection {

  protected String uri;
  protected int htl;
  protected byte[] dataBytes;
  protected byte[] metaBytes;

  FCPClientPutConnection(String uri, int htl, byte[] dataBytes, byte[] metaBytes) {
    super();
    this.htl=htl;
    this.uri=uri;
    this.dataBytes=dataBytes;
    this.metaBytes=metaBytes;
  }

  String getUri() {
    return this.uri;
  }

  int getHtl() {
    return this.htl;
  }

  boolean connect() throws ConnectionUnsuccesfullException {
    try {
      FCPLogger.log(this, "trying to insert "+this.uri+" with htl "+this.htl, FCPLogger.NORMAL);
      if (FCPUtils.checkUriSyntax(this.uri)==false) {
        throw new ConnectionUnsuccesfullException(new UriFormatErrorException());
      }
      super.connect();
      super.sendToNode(new FCPClientPutMessage(this.uri, this.htl, this.metaBytes, this.dataBytes));
      boolean dataCompletelyRetrieved=false;
      while(dataCompletelyRetrieved==false) {
        super.lastResponse=super.receiveFromNode();
        if (super.lastResponse instanceof FCPSuccessMessage) {
          FCPSuccessMessage successMessage = (FCPSuccessMessage)super.lastResponse;
          if (successMessage.getUri()!=null) {
            this.uri=successMessage.getUri();
          }
          FCPLogger.log(this, "the key "+this.uri+" was inserted succesfully "+this.htl, FCPLogger.NORMAL);
          return true;
        }
        if (super.lastResponse instanceof FCPRestartedMessage) {
          FCPLogger.log(this, "the insert of "+this.uri+" had to be restarted! please be patient.", FCPLogger.ERROR);
          continue;
        }
        if (super.lastResponse instanceof FCPPendingMessage) {
          FCPLogger.log(this, "pending message received for key "+this.uri+" insert seemes to go well...", FCPLogger.INFO);
          continue;
        }
        if (super.lastResponse instanceof FCPUriErrorMessage) {
          FCPLogger.log(this, "FCPUriErrorMessage the URI "+this.uri+" has a wrong format. ", FCPLogger.WARNING);
          return false;
        }
        if (super.lastResponse instanceof FCPFormatErrorMessage) {
          FCPLogger.log(this, "FCPFormatErrorMessage: "+super.lastResponse.getMessageString(), FCPLogger.WARNING);
          System.err.println(this.lastResponse.getMessageString());
          return false;
        }
        if (super.lastResponse instanceof FCPRouteNotFoundMessage) {
          FCPLogger.log(this, "route to key "+this.uri+" was not found.", FCPLogger.WARNING);
          return false;
        }
        if (super.lastResponse instanceof FCPSizeErrorMessage) {
          FCPLogger.log(this, "the node report a wrong size for "+this.uri, FCPLogger.WARNING);
          return false;
        }
        if (super.lastResponse instanceof FCPKeyCollisionMessage) {
          this.uri=((FCPKeyCollisionMessage)super.lastResponse).getUri();
          FCPLogger.log(this, "the key "+this.uri+" cannot be inserted because it is already there", FCPLogger.WARNING);
          return false;
        }
        throw new ConnectionUnsuccesfullException(new ResponseNotKnownException());
      }
      return false;
    }
    catch (ConnectionUnsuccesfullException e) {
      throw e;
    }
    catch (Exception  e) {
      throw new ConnectionUnsuccesfullException(e);
    }
  }
}