package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPClientHelloConnection extends FCPConnection {

  private String freenetVersion;

  FCPClientHelloConnection() {
    super();
  }

  String getFreenetVersion() {
    return this.freenetVersion;
  }

  boolean connect() throws ConnectionUnsuccesfullException {
    try {
      super.connect();
      FCPLogger.log(this, "trying to say hello to the freenet node", FCPLogger.NORMAL);
      this.sendToNode(new FCPClientHelloMessage());
      this.lastResponse = this.receiveFromNode();
      if (this.lastResponse instanceof FCPNodeHelloMessage) {
        FCPLogger.log(this, "the node answered with an hello. this is good.", FCPLogger.NORMAL);
        this.freenetVersion = ((FCPNodeHelloMessage)(this.lastResponse)).getNodeDescription();

        this.wasSuccesfull=true;
        return true;
      } else {
        FCPLogger.log(this, "the node answered with "+FCPUtils.getClassNameOnly(this.lastResponse)+". that is bad.", FCPLogger.ERROR);
        this.wasSuccesfull=false;
        return false;
      }
    }
    catch (ConnectionUnsuccesfullException e) {
      throw e;
    }
    catch (FCPException e) {
      throw new ConnectionUnsuccesfullException(e);
    }
    catch (InterruptedException e) {
      FCPLogger.log(this, "thread "+Thread.currentThread().getName()+" was interrupted!", FCPLogger.WARNING);
      throw new ConnectionUnsuccesfullException(e);
    }
  }
}

