package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPClientGetConnection extends FCPConnection {

  protected String uri;
  protected int htl;
  private byte[] metaBytes;
  private byte[] dataBytes;

  FCPClientGetConnection(String uri, int htl) {
    super();
    this.uri=uri;
    this.htl=htl;
  }

  byte[] getMetaData() {
    return this.metaBytes;
  }

  byte[] getData() {
    return this.dataBytes;
  }

  int getHtl() {
    return this.htl;
  }

  String getUri() {
    return this.uri;
  }

  boolean connect() throws ConnectionUnsuccesfullException {
    try {
      FCPLogger.log(this, "trying to get "+this.uri+" with htl "+this.htl, FCPLogger.NORMAL);
      super.connect();
      this.sendToNode(new FCPClientGetMessage(this.uri, this.htl));
      boolean dataCompletelyRetrieved=false;
      while(dataCompletelyRetrieved==false) {
        this.lastResponse=this.receiveFromNode();
        if (this.lastResponse instanceof FCPDataNotFoundMessage) {
          FCPLogger.log(this, "the key "+this.uri+" could not be found with htl "+this.htl, FCPLogger.WARNING);
          return false;
        }
        if (this.lastResponse instanceof FCPRouteNotFoundMessage) {
          FCPLogger.log(this, "no route found. probably a network problem", FCPLogger.WARNING);
          return false;
        }
        if (this.lastResponse instanceof FCPFormatErrorMessage) {
          FCPLogger.log(this, "there was an format error in the message i sent to the node: "+this.lastResponse.getMessageInfo(), FCPLogger.ERROR);
          return false;
        }
        if (this.lastResponse instanceof FCPUriErrorMessage) {
           FCPLogger.log(this, "uri error with "+this.uri+": "+this.lastResponse.getMessageInfo(), FCPLogger.WARNING);
           return false;
        }
        if (this.lastResponse instanceof FCPRestartedMessage) {
          FCPLogger.log(this, "the request "+this.uri+" was restarted. please wait some more time...", FCPLogger.NORMAL);
          dataCompletelyRetrieved=false;
          continue;
        }
        if (this.lastResponse instanceof FCPDataFoundMessage) {
          FCPLogger.log(this, "the requested data at "+this.uri+" seemes to be available. starting transfer...", FCPLogger.NORMAL);
        } else {
          FCPLogger.log(this, "there was an unexpected response: "+this.lastResponse.getMessageInfo(), FCPLogger.ERROR);
          return false;
        }
        FCPDataFoundMessage dataFoundMessage = (FCPDataFoundMessage)this.lastResponse;
        int bytesReceived = 0;
        if (dataFoundMessage.getMetaDataLength()>0) {
          FCPLogger.log(this, "receiving metadata...", FCPLogger.INFO);
          try {
            FCPDataChunkMessage metaDataChunk = this.receiveData();
            this.metaBytes=metaDataChunk.getBytes();
            FCPLogger.log(this, this.metaBytes.length+" bytes of metadata received", FCPLogger.INFO);
            if (this.metaBytes.length>dataFoundMessage.getMetaDataLength()) {
              FCPLogger.log(this, "metabytes and bytes were received together!", FCPLogger.NORMAL);
              byte[] allData = this.metaBytes;
              this.metaBytes=new byte[dataFoundMessage.getMetaDataLength()];
              this.dataBytes=new byte[dataFoundMessage.getDataLength()];
              for (int i=0; i<dataFoundMessage.getMetaDataLength(); i++) {
                this.metaBytes[i]=allData[i];
              }
              for (int i=0; i<dataFoundMessage.getDataLength(); i++) {
                this.dataBytes[i]=allData[i+this.metaBytes.length];
              }
              dataCompletelyRetrieved=true;
              break;

            }
          } catch (TransferRestartedException e) {
            FCPLogger.log(this, "the transfer of "+this.uri+"has to be restarted! ", FCPLogger.WARNING);
            continue;
          }
        } else {
          this.metaBytes=null;
        }

        FCPLogger.log(this, "receiving data...", FCPLogger.INFO);
        java.io.ByteArrayOutputStream os = new java.io.ByteArrayOutputStream(dataFoundMessage.getDataLength());
        while (bytesReceived<dataFoundMessage.getDataLength()) {
          try {
            FCPDataChunkMessage metaDataChunk = this.receiveData();
            bytesReceived+=metaDataChunk.getChunkLength();
            FCPLogger.log(this, "received "+bytesReceived+" of "+dataFoundMessage.getDataLength()+" bytes.", FCPLogger.INFO);
            os.write(metaDataChunk.getBytes());
          } catch (TransferRestartedException e) {
            FCPLogger.log(this, "the transfer of "+this.uri+"has to be restarted! ", FCPLogger.WARNING);
            continue;
          }
        }
        os.flush();
        this.dataBytes=os.toByteArray();
        FCPLogger.log(this, "completely received "+(dataFoundMessage.getDataLength()+dataFoundMessage.getMetaDataLength())+" bytes from "+this.uri+" with htl "+this.htl, FCPLogger.NORMAL);
        dataCompletelyRetrieved=true;
      }
      return true;
    }
    catch (ConnectionUnsuccesfullException e) {
      throw e;
    }
    catch (FCPException e) {
      FCPLogger.log(this, FCPUtils.getClassNameOnly(e)+" occured while transferring "+this.uri+":"+e.getMessage(), FCPLogger.WARNING);
      throw new ConnectionUnsuccesfullException(e);
    }
    catch (InterruptedException e) {
      FCPLogger.log(this, "thread "+Thread.currentThread().getName()+" was interrupted!", FCPLogger.WARNING);
      throw new ConnectionUnsuccesfullException(e);
    }
    catch (java.io.IOException e) {
      FCPLogger.log(this, "unexpected "+FCPUtils.getClassNameOnly(e)+" while transferring "+this.uri+":"+e.getMessage(), FCPLogger.ERROR);
      e.printStackTrace();
      throw new ConnectionUnsuccesfullException(e);
    }
  }

}