package freenetmessageboard.fcpinterface;

/**
 * Title:        FreenetMessageBoard - well it's a Message Board in Freenet
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author nacktschneck
 * @version 1.0
 */

class FCPByteKeywordWatcher {

  private java.util.Map keywordMap = new java.util.HashMap();
  private java.util.List keywordsFound = new java.util.LinkedList();

  FCPByteKeywordWatcher() {

  }

  void lookForKeywords(byte newByte) {
    java.util.Iterator it = this.keywordMap.keySet().iterator();
    while (it.hasNext()) {
      String keyword = (String)(it.next());
      Integer anzahl = ((Integer)(this.keywordMap.get(keyword)));
      if (anzahl.intValue()==keyword.length()) {
        if (newByte == (byte)'\n') {
          FCPLogger.log(this, "succesfully found the keyword "+keyword, FCPLogger.DEBUG);
          this.keywordsFound.add(keyword);
          anzahl = new Integer(0);
          continue;
        } else {
          anzahl = new Integer(0);
          this.keywordMap.put(keyword, anzahl);
          continue;
        }
      }
      if (newByte == keyword.charAt(anzahl.intValue())) {
        anzahl = new Integer(anzahl.intValue()+1);
        FCPLogger.log(this, anzahl.intValue()+". char of keyword "+keyword+" found!", FCPLogger.DEBUG);
        this.keywordMap.put(keyword, anzahl);
        continue;
      } else {
        anzahl = new Integer(0);
        this.keywordMap.put(keyword, anzahl);
      }
    }
  }

  boolean wasFound(String keyword) {
    return (this.keywordsFound.contains(keyword));
  }

  void addKeyword(String keyword) {
    this.keywordMap.put(keyword, new Integer(0));
   }
}