package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class UserMessage extends Message {

  private String publicKey;
  private String name;
  private String nickName;
  private String interests;
  private String description;
  private String freesiteUri;
  private String iconFileName;
  private String message;

  public UserMessage(String publicKey, String nickName, String name, String interests, String description, String freesiteUri, String iconFileName, String message) {
    super(Message.MSG_TYPE_USER);
    this.publicKey=publicKey;
    this.nickName=nickName;
    this.name=name;
    this.interests= interests;
    this.description=description;
    this.freesiteUri=freesiteUri;
    this.iconFileName=iconFileName;
    this.message=message;
    this.updateFields();
  }

  public String toShortString() {
    return "UserMessage: \""+this.nickName+"\" from "+this.getDate();
  }

  private void updateFields() {
    super.setField("public",this.publicKey);
    super.setField("nick", this.nickName);
    super.setField("name", this.name);
    super.setField("interests", this.interests);
    super.setField("description", this.description);
    super.setField("freesite", this.freesiteUri);
    super.setField("icon", this.iconFileName);
    super.setField("hello", this.message);
  }

  UserMessage(String messageString) throws MessageFormatException {
    super(messageString);
    try {
      this.publicKey=super.getField("public");
      this.nickName=super.getField("nick");
      this.name=super.getField("name");
      this.interests=super.getField("interests");
      this.description=super.getField("description");
      this.freesiteUri=super.getField("freesite");
      this.iconFileName=super.getField("icon");
      this.message=super.getField("hello");
    } catch (NoSuchFieldException ex) {
      throw new MessageFormatException(ex.getMessage());
    }
  }

  public String getPublicKey() {
    return this.publicKey;
  }

  public String getNickName() {
    return this.nickName;
  }

  public String getName() {
    return this.name;
  }

  public String getInterests() {
    return this.interests;
  }

  public String getDescription() {
    return this.description;
  }

  public String getFreesiteUri() {
    return this.freesiteUri;
  }

  public String getIconFileName() {
    return this.iconFileName;
  }

  public String getMessage() {
    return this.message;
  }
}
