package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class UserCommentMessage extends Message {

  private String userPublicKey;
  private String rating;
  private String reason;
  private String comment;
  private String helloMessage;

  public UserCommentMessage(String userPublicKey, String rating, String reason, String comment, String message) {
    super(Message.MSG_TYPE_USER_COMMENT);
    this.userPublicKey=userPublicKey;
    this.rating=rating;
    this.reason=reason;
    this.comment=comment;
    this.helloMessage=message;
    this.updateFields();
  }

  public String toShortString() {
    return "UserComment: "+this.userPublicKey+" is "+this.rating;
  }

  UserCommentMessage(String messageString) throws MessageFormatException {
    super(messageString);
    try {
      this.userPublicKey=super.getField("user");
      this.rating=super.getField("rating");
      this.reason=super.getField("reason");
      this.comment=super.getField("comment");
      this.helloMessage=super.getField("hello");
    } catch (NoSuchFieldException ex) {
      throw new MessageFormatException(ex.getMessage());
    }
  }

  public String getUserPublicKey() {
    return this.userPublicKey;
  }

  public String getRating() {
    return this.rating;
  }

  public String getReason() {
    return this.reason;
  }

  public String getComment() {
    return this.comment;
  }

  public String getMessage() {
    return this.helloMessage;
  }

  private void updateFields() {
    super.setField("user", this.userPublicKey);
    super.setField("rating", this.rating);
    super.setField("reason", this.reason);
    super.setField("comment", this.comment);
    super.setField("hello", this.helloMessage);
  }

}

