package freenetmessageboard.core;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class TreeTestFrame extends JFrame {
  JPanel contentPane;
  BorderLayout borderLayout1 = new BorderLayout();
  JTree jTree1 = new JTree();
  JTextField jTextField1 = new JTextField();

  private java.util.List allMsgs = new java.util.LinkedList();

  /**Construct the frame*/
  public TreeTestFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    this.jTree1 = new JTree(freenetmessageboard.core.NewsgroupDataModel.instance());
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    this.createMessages();
  }
  /**Component initialization*/
  private void jbInit() throws Exception  {
    //setIconImage(Toolkit.getDefaultToolkit().createImage(TreeTestFrame.class.getResource("[Your Icon]")));
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(borderLayout1);
    this.setSize(new Dimension(400, 300));
    this.setTitle("Frame Title");
    jTextField1.setText("jTextField1");
    jTextField1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jTextField1_actionPerformed(e);
      }
    });
    contentPane.add(jTree1, BorderLayout.CENTER);
    contentPane.add(jTextField1, BorderLayout.SOUTH);
  }
  /**Overridden so we can exit when window is closed*/
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }

 private PostMessage createPostMessage(String replyId, String subject) {
    PostMessage msg = new PostMessage(subject, replyId, "keywords", "message");
    msg.setOriginalUri("SSK@"+PersonalInfo.instance().getPublicKey()+"/test");
     return msg;
  }

  private void createMessages() {
    for (int i=0; i<5; i++) {
      this.allMsgs.add(this.createPostMessage("", Integer.toString(i)));
    }
    java.util.List replies=this.allMsgs;
    for (int i=0; i<4; i++) {
      replies = this.createReplies(replies);
      this.allMsgs.addAll(replies);
    }

  }

  java.util.List createReplies(java.util.List list) {
    java.util.List msgList = new java.util.LinkedList();
    java.util.Iterator it = list.iterator();
    while(it.hasNext()) {
      PostMessage msg = (PostMessage)it.next();
      for (int i=0; i<5; i++) {
        PostMessage reply = this.createPostMessage(msg.getUniqueId(), msg.getSubject()+i);
        msgList.add(reply);
      }
    }
    return msgList;
  }

  void jTextField1_actionPerformed(ActionEvent e) {
    CoreLogger.logLevel=CoreLogger.LOG_ERROR;
    int numberInserts = (int)(Math.random()*500);
    int inserts=0;
    while (this.allMsgs.size()>0 && inserts<numberInserts) {
      inserts++;
      int index = (int)(Math.random()*this.allMsgs.size());
      PostMessage msg = (PostMessage)this.allMsgs.remove(index);
      NewsgroupDataModel.instance().messageArrived(msg);
    }
  }
}