package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class PublicChannelPingPong implements MessageArrivedListener {


  public PublicChannelPingPong(boolean pinger) {
    MessageGateway.instance().startListeningOnPublicAnnouncementChannel();
    MessagePool.instance().addMessageArrivedListener(this, MessageFilter.getOtherUsersPostsMessageFilter());
    if (pinger) {
      this.sendPing();
    }
  }

  public void messageArrived(freenetmessageboard.core.Message message) {
    PostMessage postMessage = (PostMessage)message;
    if (postMessage.getSubject().equals("ping")) {
      System.err.println("Received ping, sending out pong");
      PostMessage reply = new PostMessage("pong", postMessage.getUniqueId(), "nokeys", "nomessage");
      MessageGateway.instance().sendMessageOnPublicAnnouncementChannel(reply);
    }
    if (postMessage.getSubject().equals("pong")) {
      System.err.println("Received pong, send new ping...");
      this.sendPing();
    }
  }

  private void sendPing() {
    System.err.println("Sending ping...");
    PostMessage pingMessage = new PostMessage("ping", "n/a", "nokeywords", "nomessage");
    MessageGateway.instance().sendMessageOnPublicAnnouncementChannel(pingMessage);
  }

  public static void main(String[] args) {
    PersonalInfo.instance();
  }
}