package freenetmessageboard.core;

import javax.swing.tree.DefaultMutableTreeNode;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class PostMessageTreeNode extends DefaultMutableTreeNode {

  public PostMessage postMessage;

  boolean hasUnreadChildren=false;

  public PostMessageTreeNode(PostMessage msg) {
    super(msg);
    this.postMessage=msg;
  }

  public PostMessageTreeNode(String text) {
    super(text);
  }

  void checkForUnreadChildren() {
    CoreLogger.log("checking node "+this.getUserObject().toString()+" for unread children...", CoreLogger.LOG_INFO);
    this.hasUnreadChildren=this.areThereUnreadChildren();
  }

  public String toString() {
    if (this.postMessage==null) {
      return super.getUserObject().toString();
    }
    if (BoardContent.instance().isMessageRead(postMessage.getUniqueId())) {
      if (this.hasUnreadChildren) {
        return BoardContent.instance().getBeginUnreadRepliesTag()+this.postMessage.toString()+BoardContent.instance().getEndUnreadRepliesTag();
      }
      return this.postMessage.toString();
    } else {
      return BoardContent.instance().getBeginUnreadTag()+postMessage.toString()+BoardContent.instance().getEndUnreadTag();
  //    return " ";
    }
  }

  private boolean areThereUnreadChildren() {
    if (this.getChildCount()==0) {
      return false;
    }
    java.util.Iterator it = this.children.iterator();
    while (it.hasNext()) {
      PostMessageTreeNode childNode = (PostMessageTreeNode)it.next();
      if (childNode.postMessage!=null) {
        if (BoardContent.instance().isMessageRead(childNode.postMessage.getUniqueId())==false) {
          return true;
        }
      }
      if (childNode.hasUnreadChildren) {
        return true;
      }
    }
    return false;
  }

  public void setUserObject(Object o) {
    super.setUserObject(o);
    if (o instanceof PostMessage) {
      this.postMessage=(PostMessage)o;
    }

  }

  public PostMessageTreeNode() {
    super("unreceived message");
  }

  static java.util.Comparator getDateComparator() {
    return new java.util.Comparator() {
      public int compare(Object o1, Object o2) {
        PostMessageTreeNode t1 = (PostMessageTreeNode)o1;
        PostMessageTreeNode t2 = (PostMessageTreeNode)o2;
        if (t1.postMessage==null && t2.postMessage==null) {
          return 0;
        }
        if (t1.postMessage==null) {
          return -1;
        }
        if (t2.postMessage==null) {
          return 1;
        }
        return (t1.postMessage.getDate().compareTo(t2.postMessage.getDate()));
      }
    };
  }

 static java.util.Comparator getReverseDateComparator() {
    return new java.util.Comparator() {
      public int compare(Object o1, Object o2) {
        PostMessageTreeNode t1 = (PostMessageTreeNode)o1;
        PostMessageTreeNode t2 = (PostMessageTreeNode)o2;
        if (t1.postMessage==null && t2.postMessage==null) {
          return 0;
        }
        if (t1.postMessage==null) {
          return 1;
        }
        if (t2.postMessage==null) {
          return -1;
        }
        return (-t1.postMessage.getDate().compareTo(t2.postMessage.getDate()));
      }
    };
  }
}