package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class PostMessage extends Message {

  private String subject;
  private String replyToUniqueId;
  private String keywords;
  private String message;

  public PostMessage(String subject, String replyToUniqueId, String keywords, String message) {
    super(Message.MSG_TYPE_POST);
    this.subject=subject;
    this.replyToUniqueId=replyToUniqueId;
    this.keywords=keywords;
    this.message=message;
    this.updateFields();
  }

  public String toShortString() {
    return "PostMessage: '"+this.subject+"'";
  }

  public String toString() {
    return this.subject+" ["+ContactList.instance().getNicknameOfPublicKey(this.getOriginalPublicKey())+"]";
  }

  PostMessage(String messageString) throws MessageFormatException {
    super(messageString);
    try {
      this.subject=super.getField("subject");
      this.replyToUniqueId=super.getField("replyTo");
      this.keywords=super.getField("keywords");
      this.message=super.getField("text");
    } catch (NoSuchFieldException ex) {
      throw new MessageFormatException(ex.getMessage());
    }
  }

  public String getSubject() {
    return this.subject;
  }

  public String getReplyToUniqueId() {
    return this.replyToUniqueId;
  }

  public String getKeywords() {
    return this.keywords;
  }

  public String getMessage() {
    return this.message;
  }

  private void updateFields() {
    super.setField("subject", this.subject);
    super.setField("replyTo", this.replyToUniqueId);
    super.setField("keywords", this.keywords);
    super.setField("text", this.message);
  }
}
