package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class PostCommentMessage extends Message {

  private String commentedMessageId;
  private String commentedMessageUri;
  private String rating;
  private String reason;
  private String keywords;

  public PostCommentMessage(String commentedMessageId, String commentedMessageUri, String rating, String reason, String keywords) {
    super(Message.MSG_TYPE_POST_COMMENT);
    this.commentedMessageId=commentedMessageId;
    this.commentedMessageUri=commentedMessageUri;
    this.rating=rating;
    this.reason=reason;
    this.keywords=keywords;
    this.updateFields();
  }

  PostCommentMessage(String messageString) throws MessageFormatException {
    super(messageString);
    try {
      this.commentedMessageId=super.getField("messageId");
      this.commentedMessageUri=super.getField("messageUri");
      this.rating=super.getField("rating");
      this.reason=super.getField("reason");
      this.keywords=super.getField("keywords");
    } catch (NoSuchFieldException ex) {
      throw new MessageFormatException(ex.getMessage());
    }
  }

  public String getCommentedMessageId() {
    return this.commentedMessageId;
  }

  public String getCommentedMessageUri() {
    return this.commentedMessageUri;
  }

  public String getRating() {
    return this.rating;
  }

  public String getReason() {
    return this.reason;
  }

  public String getKeywords() {
    return this.getKeywords();
  }

  private void updateFields() {
    super.setField("messageId", this.commentedMessageId);
    super.setField("messageUri", this.commentedMessageUri);
    super.setField("rating", this.rating);
    super.setField("reason", this.reason);
    super.setField("keywords", this.keywords);
  }
}