package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class PersonalInfo {

  private String publicKey;
  private String privateKey;
  private String nickName = "Anon";
  private String name = "Anonymous Coward";
  private String interests  = "none of your business";
  private String freesiteUri  = "none of your business";;
  private String description = "none of your business";;
  private String iconFileName = "none of your business";;
  private String helloMessage = "I'm new to fmb, please start listening on my channel";

  private static String personalInfoFileName="personalInfo";
  private static String demonNick;

  private static boolean demonInfo=false;


  private static boolean isDefault=false;
  private static PersonalInfo instance;

  public void saveToDisk() throws java.io.IOException {
    try {
      java.io.FileWriter fileWriter = new java.io.FileWriter(PersonalInfo.personalInfoFileName);
      fileWriter.write(this.getString());
      fileWriter.close();
    } catch (java.io.IOException ex) {
      throw new java.io.IOException("couldn't save to "+PersonalInfo.personalInfoFileName+": "+ex.getMessage());
    }
  }

  String publicToPrivateUri(String publicUri) {
    return "SSK@"+this.privateKey+publicUri.substring(publicUri.indexOf('/'));
  }

  String privateToPublicUri(String privateUri) {
    return "SSK@"+this.publicKey+privateUri.substring(privateUri.indexOf('/'));
  }

  public String getString() {
    java.util.Map fieldsMap = new java.util.HashMap();
    fieldsMap.put("publicKey", publicKey);
    fieldsMap.put("privateKey", privateKey);
    fieldsMap.put("nickName", nickName);
    fieldsMap.put("description", description);
    fieldsMap.put("name", name);
    fieldsMap.put("interests", interests);
    fieldsMap.put("freesiteUri", freesiteUri);
    fieldsMap.put("iconFileName", iconFileName);
    fieldsMap.put("helloMessage", helloMessage);
    StringBuffer buf = new StringBuffer(200);
    buf.append("<personalInfo>\n");
    buf.append(Message.constructFieldTags(fieldsMap));
    buf.append("</personalInfo>\n");
    return buf.toString();
  }

  static PersonalInfo getForwarderInfo(String forwarderNick) {
    PersonalInfo info = new PersonalInfo();
    info.nickName=forwarderNick;
    info.name="automatic message forwarder";
    info.interests="forwarding messages";
    info.description="I automatically collect messages and forward them on my channel.";
    info.helloMessage="listen to this channel for fast collecting of messages";
    return info;
  }

  private static PersonalInfo readFromDisk(String fileName) throws java.io.IOException, MessageFormatException {
    StringBuffer buf = new StringBuffer(200);
    try {
      java.io.FileReader fileReader = new java.io.FileReader(PersonalInfo.personalInfoFileName);
      java.io.LineNumberReader lnr = new java.io.LineNumberReader(fileReader);
      String nextLine;

      while(true) {
        nextLine = lnr.readLine();
        if (nextLine==null) break;
        buf.append(nextLine);
      }
      lnr.close();
      fileReader.close();
    } catch (java.io.IOException ex) {
      CoreLogger.log("can't read from file "+PersonalInfo.personalInfoFileName+": "+ex.getClass().getName()+": "+ex.getMessage(), CoreLogger.LOG_WARNING);
      throw new java.io.IOException("failed to read from "+PersonalInfo.personalInfoFileName+": "+ex.getMessage());
    }

    java.util.Map fieldsMap;
    try {
      fieldsMap = Message.getFields(buf.toString(), "personalInfo");
    } catch (MessageFormatException ex) {
      throw ex;
    }

    PersonalInfo info = new PersonalInfo();
    info.description=(String)fieldsMap.get("description");
    info.freesiteUri=(String)fieldsMap.get("freesiteUri");
    info.helloMessage=(String)fieldsMap.get("helloMessage");
    info.iconFileName=(String)fieldsMap.get("iconFileName");
    info.interests=(String)fieldsMap.get("interests");
    info.name=(String)fieldsMap.get("name");
    info.nickName=(String)fieldsMap.get("nickName");
    info.privateKey=(String)fieldsMap.get("privateKey");
    info.publicKey=(String)fieldsMap.get("publicKey");
    return info;
  }

  private PersonalInfo() {
    try {
      freenetmessageboard.fcpinterface.KeyPair keyPair = freenetmessageboard.fcpinterface.FCPFacade.instance().generateKeyPair();
      this.publicKey=keyPair.getPublicKey();
      this.privateKey=keyPair.getPrivateKey();
      CoreLogger.log("generated keypair with public key "+this.publicKey, CoreLogger.LOG_NORMAL);
    } catch (freenetmessageboard.fcpinterface.FailedToConnectToNodeException ex) {
      CoreLogger.log("couldn't generate keypair: "+ex.getMessage(), CoreLogger.LOG_ERROR);
      System.exit(-1);
    }
  }



  public void updateInfoFromDialog(freenetmessageboard.gui.PersonalInfoDialog dialog) {
    this.publicKey=dialog.publicKeyTextField.getText();
    this.privateKey=dialog.privateKeyTextField.getText();
    this.nickName=dialog.nickTextField.getText();
    this.name=dialog.nameTextField.getText();
    this.freesiteUri=dialog.freesiteUriTextField.getText();
    this.interests=dialog.interestsTextField.getText();
    this.description=dialog.descriptionTextArea.getText();
    this.helloMessage=dialog.messageTextArea.getText();
  }

  public void updateInfoFromUserMessage(UserMessage userMsg) {
    this.nickName=userMsg.getNickName();
    this.name=userMsg.getName();
    this.freesiteUri=userMsg.getFreesiteUri();
    this.interests=userMsg.getInterests();
    this.description=userMsg.getDescription();
    this.helloMessage=userMsg.getMessage();
    try {
      this.saveToDisk();
    } catch (java.io.IOException ex) {
      CoreLogger.log("failed to save the updated personal info to disk: "+ex.getMessage(), CoreLogger.LOG_ERROR);
    }
  }

  public UserMessage createUserMessage() {
    return new UserMessage(this.publicKey, this.nickName, this.name, this.interests, this.description, this.freesiteUri, this.iconFileName, this.helloMessage);
  }

  public static void setDemonMode(String demonName) {
    PersonalInfo.personalInfoFileName="demonInfo";
    PersonalInfo.demonNick=demonName;
  }

  public boolean isDefault() {
    return this.isDefault;
  }

  public static synchronized PersonalInfo instance() {
    if (PersonalInfo.instance==null) {
      try {
        PersonalInfo.instance=PersonalInfo.readFromDisk(PersonalInfo.personalInfoFileName);
      } catch (Exception ex) {
        CoreLogger.log("failed to read personal information from local disk, creating new identity...", CoreLogger.LOG_WARNING);
        if (PersonalInfo.demonInfo) {
          PersonalInfo.instance=PersonalInfo.getForwarderInfo(PersonalInfo.demonNick);
        } else {
          PersonalInfo.instance=new PersonalInfo();
          PersonalInfo.isDefault=true;
        }
      }
      try {
        PersonalInfo.instance.saveToDisk();
      } catch (Exception ex) {
        CoreLogger.log("failed to save the personal information to local disk", CoreLogger.LOG_WARNING);
      }
    }
    return PersonalInfo.instance;
  }

  public String getName() {
    return this.name;
  }

  public String getInterests() {
    return this.interests;
  }

  public String getFreesiteUri() {
    return this.freesiteUri;
  }

  public String getMessage() {
    return this.helloMessage;
  }

  public String getDescription() {
    return this.description;
  }

  public String getIconFileName() {
    return this.iconFileName;
  }

  public String getPublicKey() {
    return this.publicKey;
  }

  public String getNickname() {
    return this.nickName;
  }

  public String getPrivateKey() {
    return this.privateKey;
  }
}