package freenetmessageboard.core;

import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import java.util.Enumeration;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class NewsgroupPost implements javax.swing.tree.MutableTreeNode {

  private java.util.List repliesList = new java.util.LinkedList();

  private PostMessage postMessage;
  private String title;

  private boolean hasReverseSorting=false;

  private NewsgroupPost parentPost;

  private boolean isUnread=true;
  private int unreadChildCount=0;

  private boolean hasTemporaryPosition=false;

  public NewsgroupPost(PostMessage postMessage, boolean unread) {
    this.isUnread=unread;
    this.postMessage=postMessage;
  }

  public javax.swing.Icon getIcon() {
    if (this.isUnread==false) {
      if (this.getChildCount()==0) {
        return freenetmessageboard.gui.ColorsAndIcons.msgIcon;
      }
      if (this.getUnreadChildCount()==0) {
        return freenetmessageboard.gui.ColorsAndIcons.msgRepliesIcon;
      }
      return freenetmessageboard.gui.ColorsAndIcons.msgUnreadRepliesIcon;
    }
    if (this.getChildCount()==0) {
      return freenetmessageboard.gui.ColorsAndIcons.msgUnreadIcon;
    }
    return freenetmessageboard.gui.ColorsAndIcons.msgRepliesUnreadIcon;
  }

  public NewsgroupPost(String title, boolean unread) {
    this.isUnread=unread;
    this.title=title;
    this.hasReverseSorting=true;
  }

  void setHasTemporaryPosition(boolean b) {
    this.hasTemporaryPosition=b;
  }

  void decreaseUnreadChildCount(int i) {
    this.unreadChildCount-=i;
    if (this.getParent()!=null) {
      ((NewsgroupPost)this.getParent()).decreaseUnreadChildCount(i);
    }
    NewsgroupDataModel.instance().fireTreeNodeChanged(this);
  }

  public boolean isUnread() {
    return this.isUnread;
  }

  public int getUnreadChildCount() {
    return this.unreadChildCount;
  }

  void increaseUnreadChildCount(int i) {
    this.unreadChildCount+=i;
    if (this.getParent()!=null) {
      ((NewsgroupPost)this.getParent()).increaseUnreadChildCount(i);
    }
    NewsgroupDataModel.instance().fireTreeNodeChanged(this);
  }

  void markAsRead() {
    if (this.isUnread) {
      this.isUnread=false;
      ((NewsgroupPost)this.getParent()).decreaseUnreadChildCount(1);
    }
  }

  boolean hasTemporaryPosition() {
    return this.hasTemporaryPosition;
  }

  public PostMessage getPostMessage() {
    return this.postMessage;
  }

  public String toString() {

    StringBuffer buf = new StringBuffer();
    if (this.postMessage!=null) {
      buf.append(this.postMessage.getSubject());
      buf.append(" [");
      buf.append(ContactList.instance().getNicknameOfPublicKey(this.postMessage.getOriginalPublicKey()));
      buf.append(" ] ");
    } else {
      buf.append(this.title);
    }
    return buf.toString();
  }

  public Enumeration children()  {
    return java.util.Collections.enumeration(this.repliesList);
  }

  public boolean getAllowsChildren() {
    return true;
  }

  public TreeNode getChildAt(int childIndex) {
    TreeNode child = (TreeNode)this.repliesList.get(childIndex);;
 //   CoreLogger.log("the child of node "+this.toString()+" at pos "+childIndex+" is "+child.toString(), CoreLogger.LOG_INFO);
    return child;
  }

  public int getChildCount() {
 //   CoreLogger.log("the  node "+this.toString()+" has  "+this.repliesList.size()+" children", CoreLogger.LOG_INFO);
    return this.repliesList.size();
  }


  public int getIndex(TreeNode node) {
    int index = this.repliesList.indexOf(node);;
//    CoreLogger.log("the index of node "+node.toString()+" at parent "+this.toString()+" is "+index, CoreLogger.LOG_INFO);
    return index;
  }

  public TreeNode getParent() {
    return this.parentPost;
  }

  public boolean isLeaf() {
    return( this.repliesList.size()==0);
  }

  void insertNewsgroupPost(NewsgroupPost post) {
    this.insert(post, 0);
  }

  public void insert(MutableTreeNode child, int index) {
    this.repliesList.add(index, child);
    child.setParent(this);
    java.util.Comparator comp;
    if (this.hasReverseSorting) {
      comp = NewsgroupPost.getReverseDateComparator();
    } else {
      comp = NewsgroupPost.getDateComparator();
    }
    java.util.Collections.sort(this.repliesList, comp);
    int unreadIncr=0;
    if (((NewsgroupPost)child).isUnread) {
     unreadIncr+=1;
    }
    unreadIncr+=((NewsgroupPost)child).getUnreadChildCount();
    this.increaseUnreadChildCount(unreadIncr);
  }

  public void remove(int index) {
    NewsgroupPost post = (NewsgroupPost)this.repliesList.get(index);
    this.repliesList.remove(post);
  }

  public void remove(MutableTreeNode node) {
    int unreadDecr=0;
    if (((NewsgroupPost)node).isUnread) {
      unreadDecr++;
    }
    unreadDecr+=((NewsgroupPost)node).getUnreadChildCount();
    this.decreaseUnreadChildCount(unreadDecr);
    this.repliesList.remove(node);
  }

  public void removeFromParent() {
    this.parentPost.remove(this);
    this.parentPost=null;
  }

  public void setParent(MutableTreeNode newParent) {
    this.parentPost=(NewsgroupPost)newParent;
  }

  public void setUserObject(Object o) {
    if (o instanceof PostMessage) {
      this.updatePostMessage((PostMessage)o);
    } else {
      this.title=o.toString();
    }
  }

  void updatePostMessage(PostMessage postMsg) {
    this.postMessage=postMsg;
  }

  static java.util.Comparator getDateComparator() {
    return new java.util.Comparator() {
      public int compare(Object o1, Object o2) {
        NewsgroupPost t1 = (NewsgroupPost)o1;
        NewsgroupPost t2 = (NewsgroupPost)o2;
        if (t1.postMessage==null && t2.postMessage==null) {
          return 0;
        }
        if (t1.postMessage==null) {
          return -1;
        }
        if (t2.postMessage==null) {
          return 1;
        }
        return (t1.postMessage.getDate().compareTo(t2.postMessage.getDate()));
      }
    };
  }

 static java.util.Comparator getReverseDateComparator() {
    return new java.util.Comparator() {
      public int compare(Object o1, Object o2) {
        NewsgroupPost t1 = (NewsgroupPost)o1;
        NewsgroupPost t2 = (NewsgroupPost)o2;
        if (t1.postMessage==null && t2.postMessage==null) {
          return 0;
        }
        if (t1.postMessage==null) {
          return 1;
        }
        if (t2.postMessage==null) {
          return -1;
        }
        return (-t1.postMessage.getDate().compareTo(t2.postMessage.getDate()));
      }
    };
  }

}