package freenetmessageboard.core;


import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;
/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */



public class NewsgroupDataModel implements MessageArrivedListener, javax.swing.table.TableModel, javax.swing.tree.TreeModel {

  private static NewsgroupDataModel instance;

  // for implementing TableModel
  private java.util.List tableModelListenerList = new java.util.LinkedList();
  private String[] tableColumnTitles = { "new", "from", "subject", "date", "reply to" };
  private Class[] tableColumnClasses = { freenetmessageboard.gui.ColorsAndIcons.msgIcon.getClass(), new String().getClass(), new String().getClass(), new String().getClass(), new String().getClass() };

  // for implementing treeModel;
  private NewsgroupPost rootNode;
  private NewsgroupPost unlinkedRepliesNode;
  private java.util.List treeModelListenerList = new java.util.LinkedList();

  // for data storage;
  private java.util.Map newsgroupPostsMap = new java.util.HashMap();
  private java.util.Set missingUniqueIdSet = new java.util.HashSet();
  private java.util.List allPostMessagesList = new java.util.ArrayList();

  private String newsgroupName;

  private boolean markNewsMessagesAsUnread=true;

  private NewsgroupDataModel(String newsgroupName) {
    MessagePool.instance().addMessageArrivedListener(this, MessageFilter.getAllPostsMessageFilter());
    this.rootNode=new NewsgroupPost(newsgroupName, false);
    this.newsgroupName=newsgroupName;
  }

  public static NewsgroupDataModel instance() {
    if (NewsgroupDataModel.instance==null) {
      NewsgroupDataModel.instance=new NewsgroupDataModel("all newsgroups");
    }
    return NewsgroupDataModel.instance;
  }

  private void fireRowsInserted(int i) {
    java.util.Iterator it = this.tableModelListenerList.iterator();
    javax.swing.event.TableModelEvent event = new javax.swing.event.TableModelEvent(this, i);
    while (it.hasNext()) {
      TableModelListener listener = (TableModelListener)it.next();
      listener.tableChanged(event);
    }
  }


  public PostMessage getPostMessageInRow(int row) {
    PostMessage post = (PostMessage)this.allPostMessagesList.get(row);
    return post;
  }

  public NewsgroupPost getTreeNodeForMessage(PostMessage msg) {
    return (NewsgroupPost)this.newsgroupPostsMap.get(msg.getUniqueId());
  }

  public void messageArrived(Message msg) {
    CoreLogger.log("new message arrived in newsgroup: "+msg.toShortString(), CoreLogger.LOG_INFO);

    PostMessage postMsg = (PostMessage)msg;
    NewsgroupPost newPost = (NewsgroupPost)this.newsgroupPostsMap.get(((PostMessage)msg).getUniqueId());


    synchronized(this.rootNode) {

      if (newPost!=null) {
        CoreLogger.log("it does exist in the tree, only needs to be updated...", CoreLogger.LOG_INFO);
        int index = this.allPostMessagesList.indexOf(newPost.getPostMessage());
        this.allPostMessagesList.remove(index);
        newPost.updatePostMessage(postMsg);
        this.allPostMessagesList.add(index, postMsg);

      } else {
        CoreLogger.log("it does not exist in the tree yet, creating a node and finding out where to put it...", CoreLogger.LOG_INFO);
        newPost = new NewsgroupPost(postMsg, this.markNewsMessagesAsUnread);
        this.newsgroupPostsMap.put(msg.getUniqueId(), newPost);
        this.allPostMessagesList.add(msg);
        this.fireRowsInserted(this.allPostMessagesList.size()-1);
        if (postMsg.getReplyToUniqueId().length()==0) {
          CoreLogger.log("it is not a reply, so it goes to the root...", CoreLogger.LOG_INFO);
          this.rootNode.insertNewsgroupPost(newPost);

          TreePath path = this.getPathToRoot((NewsgroupPost)newPost.getParent());
          this.fireTreeNodeInserted(path, new int[] { this.rootNode.getIndex(newPost) }, new Object[] { newPost });

        } else {
          NewsgroupPost prevPos = (NewsgroupPost)this.newsgroupPostsMap.get(postMsg.getReplyToUniqueId());
          if (prevPos==null) {
            CoreLogger.log("it is a reply to a message that has not yet been received...", CoreLogger.LOG_INFO);
            this.addPostToUnlinkedRepliesNode(newPost);
          } else {
            CoreLogger.log("it is a reply to "+prevPos.getPostMessage().toShortString()+", adding it to that node...", CoreLogger.LOG_INFO);
            prevPos.insertNewsgroupPost(newPost);

            TreePath path = this.getPathToRoot((NewsgroupPost)prevPos);
            this.fireTreeNodeInserted(path, new int[] { prevPos.getIndex(newPost) }, new Object[] { newPost });
          }
        }
        if (this.markNewsMessagesAsUnread==false) {
          newPost.markAsRead();
        }
      }

      CoreLogger.log("looking if there are replies to "+postMsg.toShortString()+" in the temp thread...", CoreLogger.LOG_INFO);

      if (this.missingUniqueIdSet.contains(postMsg.getUniqueId())) {
      CoreLogger.log("there are replies to "+postMsg.toShortString()+" in the temp thread, moving them to the new node...", CoreLogger.LOG_INFO);
        this.movePostsFromUnlinkedRepliesNode(newPost);
      }

 //     this.fireTreeStructureChanged(this.rootNode);

    }
  }

  public void markAsRead(String uniqueId) {
    NewsgroupPost post = (NewsgroupPost)this.newsgroupPostsMap.get(uniqueId);
    if (post==null) return;
    post.markAsRead();
  }

  public void setMarkNewMessagesAsUnread(boolean b) {
    this.markNewsMessagesAsUnread=b;
  }

  void fireTreeNodeChanged(NewsgroupPost post) {
    TreePath path = this.getPathToRoot(post);
    TreeModelEvent event = new TreeModelEvent(this, path);
    java.util.Iterator it = this.treeModelListenerList.iterator();
    while (it.hasNext()) {
      TreeModelListener listener = (TreeModelListener)it.next();
      listener.treeNodesInserted(event);
    }
  }

  private void fireTreeNodeInserted(TreePath path, int[] indices, Object[] objects) {
    CoreLogger.log("inserting nodes to this path: ", CoreLogger.LOG_INFO);
    Object[] nodes = path.getPath();
    for (int i=0; i<nodes.length; i++) {
      CoreLogger.log("- "+nodes[i].toString(), CoreLogger.LOG_INFO);
    }
    CoreLogger.log("inesrting these objects: ", CoreLogger.LOG_INFO);
    for (int i=0; i<indices.length; i++) {
      CoreLogger.log("- "+indices[i]+": "+objects[i].toString(), CoreLogger.LOG_INFO);
    }
    TreeModelEvent event = new TreeModelEvent(this, path, indices, objects);
    java.util.Iterator it = this.treeModelListenerList.iterator();
    while (it.hasNext()) {
      TreeModelListener listener = (TreeModelListener)it.next();
      listener.treeNodesInserted(event);
    }
  }

  private void fireTreeNodeRemoved(TreePath path, int[] indices, Object[] objects) {
    CoreLogger.log("removing nodes from this path: ", CoreLogger.LOG_INFO);
    Object[] nodes = path.getPath();
    for (int i=0; i<nodes.length; i++) {
      CoreLogger.log("- "+nodes[i].toString(), CoreLogger.LOG_INFO);
    }
    CoreLogger.log("removing these objects: ", CoreLogger.LOG_INFO);
    for (int i=0; i<indices.length; i++) {
      CoreLogger.log("- "+indices[i]+": "+objects[i].toString(), CoreLogger.LOG_INFO);
    }
    TreeModelEvent event = new TreeModelEvent(this, path, indices, objects);
    java.util.Iterator it = this.treeModelListenerList.iterator();
    while (it.hasNext()) {
      TreeModelListener listener = (TreeModelListener)it.next();
      listener.treeNodesRemoved(event);
    }
  }

  private void fireTreeStructureChanged(NewsgroupPost beginning) {
    TreePath treePath = this.getPathToRoot(beginning);
    TreeModelEvent event = new TreeModelEvent(this, treePath);
    java.util.Iterator it = this.treeModelListenerList.iterator();
    while (it.hasNext()) {
      TreeModelListener listener = (TreeModelListener)it.next();
      listener.treeStructureChanged(event);
    }
  }


  public TreePath getPathToRoot(NewsgroupPost post) {
  //  CoreLogger.log("path to root for post "+post.toString()+":", CoreLogger.LOG_INFO);
    java.util.List pathList = new java.util.LinkedList();
    NewsgroupPost currentPost = post;
    while(currentPost!=null) {
      pathList.add(0, currentPost);
      currentPost=(NewsgroupPost)currentPost.getParent();
    }
    if (post.getPostMessage()!=null) {
     // CoreLogger.log("path to root for post "+post.toString()+" has "+pathList.size()+" nodes", CoreLogger.LOG_INFO);
    }
    return new TreePath(pathList.toArray(new NewsgroupPost[pathList.size()]));
  }

  private void movePostsFromUnlinkedRepliesNode(NewsgroupPost prevPost) {
    CoreLogger.log("moving all replies to "+prevPost.getPostMessage().toShortString()+" from temporary thread...", CoreLogger.LOG_INFO);
    int childPos = 0;
    int[] removedIndices= new int[this.unlinkedRepliesNode.getChildCount()];
    int removedCount=0;
    java.util.List removedPostsList = new java.util.LinkedList();
    while (childPos<this.unlinkedRepliesNode.getChildCount()) {
      NewsgroupPost post = (NewsgroupPost)this.unlinkedRepliesNode.getChildAt(childPos);
      if (post.getPostMessage().getReplyToUniqueId().equals(prevPost.getPostMessage().getUniqueId())) {
        CoreLogger.log("the msg "+post.getPostMessage().toShortString()+" from pos "+childPos+" is added to the new node.", CoreLogger.LOG_INFO);
        post.removeFromParent();
        prevPost.insertNewsgroupPost(post);
        removedPostsList.add(post);
        removedIndices[removedCount]=childPos;
        removedCount++;
      } else {
        childPos++;
      }
    }
    if (removedCount!=0) {
      int[] newArrayForRemovedIndices = new int[removedCount];
      System.arraycopy(removedIndices, 0, newArrayForRemovedIndices, 0, removedCount);
      Object[] movedNodes = removedPostsList.toArray(new NewsgroupPost[removedPostsList.size()]);
      CoreLogger.log("indices have length "+newArrayForRemovedIndices.length+", nodes have length "+movedNodes.length, CoreLogger.LOG_INFO);
      for (int i=0; i<newArrayForRemovedIndices.length; i++) {
        CoreLogger.log("removed indices: ", CoreLogger.LOG_INFO);
        CoreLogger.log(newArrayForRemovedIndices[i]+": "+((NewsgroupPost)movedNodes[i]).toString(), CoreLogger.LOG_INFO);
      }
      this.fireTreeNodeRemoved(this.getPathToRoot(this.unlinkedRepliesNode), newArrayForRemovedIndices, movedNodes);
      int[] newChildIndices = new int[newArrayForRemovedIndices.length];
      for (int i=0; i<newChildIndices.length; i++) {
        newChildIndices[i]=i;
      }
      this.fireTreeNodeInserted(this.getPathToRoot(prevPost), newChildIndices, movedNodes);
    }
    if (this.unlinkedRepliesNode.getChildCount()==0) {
      CoreLogger.log("removing the temporary thread because it has no more children", CoreLogger.LOG_INFO);
      int index = this.rootNode.getIndex(this.unlinkedRepliesNode);
      int oldIndex = this.rootNode.getIndex(this.unlinkedRepliesNode);
      this.unlinkedRepliesNode.removeFromParent();
      this.fireTreeNodeRemoved(this.getPathToRoot(this.rootNode), new int[] { oldIndex }, new Object[] { this.unlinkedRepliesNode });
      this.unlinkedRepliesNode=null;
    }
    this.missingUniqueIdSet.remove(prevPost.getPostMessage().getUniqueId());
    CoreLogger.log("finished moving.", CoreLogger.LOG_INFO);
  }

  private void addPostToUnlinkedRepliesNode(NewsgroupPost post) {
    this.missingUniqueIdSet.add(post.getPostMessage().getReplyToUniqueId());
    if (this.unlinkedRepliesNode==null) {
      CoreLogger.log("adding the temporary thread because it wasn't there yet", CoreLogger.LOG_INFO);
      this.unlinkedRepliesNode=new NewsgroupPost("replies to unreceived messages...", false);
      this.rootNode.insertNewsgroupPost(this.unlinkedRepliesNode);

      TreePath path = this.getPathToRoot(this.rootNode);
      this.fireTreeNodeInserted(path, new int[] { this.rootNode.getIndex(this.unlinkedRepliesNode) }, new Object[] { this.unlinkedRepliesNode });

    }
    this.unlinkedRepliesNode.insertNewsgroupPost(post);

    TreePath path = this.getPathToRoot(this.unlinkedRepliesNode);
    this.fireTreeNodeInserted(path, new int[] { this.unlinkedRepliesNode.getIndex(post) }, new Object[] { post });

    CoreLogger.log("added "+post.getPostMessage().toShortString()+" to the temporary thread", CoreLogger.LOG_NORMAL);
  }

  public Object getChild(Object parent, int index) {
    return ((NewsgroupPost)parent).getChildAt(index);
  }

  public int getChildCount(Object parent) {
    return ((NewsgroupPost)parent).getChildCount();
  }

  public int getIndexOfChild(Object parent, Object child) {
    return ((NewsgroupPost)parent).getIndex((NewsgroupPost)child);
  }

  public Object getRoot() {
    return this.rootNode;
  }

  public boolean isLeaf(Object node) {
    return ((NewsgroupPost)node).isLeaf();
  }

  public void addTreeModelListener(TreeModelListener l) {
    CoreLogger.log("tree model listener added: "+l.toString(), CoreLogger.LOG_INFO );
    this.treeModelListenerList.add(l);
  }


  public void removeTreeModelListener(TreeModelListener l) {
    this.treeModelListenerList.remove(l);
  }

  public void valueForPathChanged(TreePath path, Object newValue) {

  }


  // methods of interface TableModel:

  public int getColumnCount() {
    return this.tableColumnTitles.length;
  }

  public int getRowCount() {
    return this.newsgroupPostsMap.size();
  }

  public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    return;
  }

  public Object getValueAt(int rowIndex, int columnIndex) {
    try {

      PostMessage msg = (PostMessage)this.allPostMessagesList.get(rowIndex);
      NewsgroupPost post = (NewsgroupPost)this.newsgroupPostsMap.get(msg.getUniqueId());
      switch (columnIndex) {
        case 0:
          return post.getIcon();
        case 1:
          if (msg.getOriginalPublicKey().equals(msg.getSourceKey())) {
            return ContactList.instance().getNicknameOfPublicKey(msg.getOriginalPublicKey());
          } else {
            return ContactList.instance().getNicknameOfPublicKey(msg.getOriginalPublicKey())+" (unverified)";
          }
        case 2:
          return msg.getSubject();
        case 3:
          return msg.getDate();
        case 4:
          if (post.getParent().equals(this.rootNode)) return null;
          if (post.getParent().equals(this.unlinkedRepliesNode)) return "?";
          return ContactList.instance().getNicknameOfPublicKey(((NewsgroupPost)post.getParent()).getPostMessage().getOriginalPublicKey());
      }
      return "no value";
    } catch (Throwable t) {
      CoreLogger.log("failed to get data from table model: row "+rowIndex+", col "+columnIndex , CoreLogger.LOG_ERROR);
      t.printStackTrace();
      CoreLogger.log("don't worry about the stacktrace, the program should keep working fine...", CoreLogger.LOG_ERROR);
      return "no value";
    }
  }

  public Class getColumnClass(int columnIndex) {
    return this.tableColumnClasses[columnIndex];
  }


  public String getColumnName(int columnIndex) {
    return this.tableColumnTitles[columnIndex];
  }


  public boolean isCellEditable(int rowIndex, int columnIndex) {
    return false;
  }

  public void removeTableModelListener(TableModelListener l) {
    this.tableModelListenerList.remove(l);
  }

  public void addTableModelListener(TableModelListener l)  {

    this.tableModelListenerList.add(l);
  }

}