package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class MessagePool extends java.lang.Thread {

  private static MessagePool instance;

  private java.util.Map allMessages = new java.util.HashMap();

  private java.util.Map newMessages = new java.util.HashMap();

  private java.util.Map lastMessageFromUser = new java.util.HashMap();

  private java.util.Map messageArrivedListener = new java.util.HashMap();

  private java.util.Set messagesToBeIgnored = new java.util.TreeSet();

  private MessageFilter incomingMessageFilter = MessageFilter.getAcceptAllMessageFilter();

  private static String messagePoolFileName="messages";
  private static String ignoredMessagesFileName="ignoredMessages";


  private MessagePool() {
    this.setName("MessagePool");
  }

  public static MessagePool readMessagePoolFromDisk() throws java.io.IOException {
    CoreLogger.log("reading the message pool from disk...", CoreLogger.LOG_NORMAL);
    MessagePool pool = new MessagePool();

  /*  try {
      java.io.FileReader fileReader = new java.io.FileReader(MessagePool.ignoredMessagesFileName);
      java.io.LineNumberReader lnr = new java.io.LineNumberReader(fileReader);
      String nextLine = lnr.readLine();
      while(nextLine!=null) {
        pool.messagesToBeIgnored.add(nextLine);
        nextLine=lnr.readLine();
      }
    } catch (Exception ex) {
      CoreLogger.log("failed to read ignored messages file: "+ex.getClass()+": "+ex.getMessage(), CoreLogger.LOG_WARNING);
    }*/

    pool.incomingMessageFilter=MessageFilter.ignoreByUniqueIDFilter(pool.messagesToBeIgnored);

    try {
      java.io.FileReader fileReader = new java.io.FileReader(MessagePool.messagePoolFileName);
      java.io.LineNumberReader lnr = new java.io.LineNumberReader(fileReader);
      StringBuffer buf = new StringBuffer(400);
      while(true) {
        String nextLine = lnr.readLine();
        if (nextLine==null) {
          break;
        }
        buf.append(nextLine);
        buf.append('\n');

        if (nextLine.equals("</message>")) {
          Message message = Message.parseString(buf.toString());
          pool.addMessage(message.getSourceUri(), message);
          buf = new StringBuffer(400);
        }
      }
      CoreLogger.log("read the message pool from disk.", CoreLogger.LOG_NORMAL);
      return pool;
    } catch (java.lang.Exception ex) {
      CoreLogger.log("error reading the message pool from disk: "+ex.getClass().getName()+": "+ex.getMessage(), CoreLogger.LOG_ERROR);
      throw new java.io.IOException(ex.getMessage());
    }

  }


  public synchronized MessageArchive createArchive(MessageFilter filter) throws java.io.IOException {
    CoreLogger.log("creating a message pool archive...", CoreLogger.LOG_NORMAL);
    MessageArchive archive;
    synchronized(this.allMessages) {
      java.util.List messagesList = new java.util.LinkedList();
      java.util.Iterator it = this.allMessages.values().iterator();
      while(it.hasNext()) {
        Message msg = (Message)it.next();
        if (filter.acceptMessage(msg)) {
          messagesList.add(msg);
        }
      }
      java.util.Collections.sort(messagesList, Message.getReverseDateComparator());
      Message[] messages = (Message[])messagesList.toArray(new Message[messagesList.size()]);
      archive = new MessageArchive(messages, "complete archive from "+PersonalInfo.instance().getNickname()+"'s messagepool ");
    }
    return archive;
  }

  private java.util.List getCertainMessages(MessageFilter filter, boolean reverseSorting) {
    java.util.List msgList = new java.util.ArrayList(100);
    synchronized(this.allMessages) {
      java.util.Iterator it = this.allMessages.values().iterator();
      while(it.hasNext()) {
        Message msg = (Message)it.next();
        if (filter.acceptMessage(msg)) {
          msgList.add(msg);
        }
      }
    }
    if (reverseSorting) {
      java.util.Collections.sort(msgList, Message.getReverseDateComparator());
    } else {
      java.util.Collections.sort(msgList, Message.getDateComparator());
    }
    return msgList;
  }

  public synchronized void saveToDisk() throws java.io.IOException  {


    CoreLogger.log("saving the message pool to disk...", CoreLogger.LOG_WARNING);
    try {
      java.io.File oldFile =new java.io.File(this.messagePoolFileName);
      oldFile.renameTo(new java.io.File(this.messagePoolFileName+".backup"));

      java.io.FileOutputStream fileOutputStream = new java.io.FileOutputStream(this.messagePoolFileName);
      this.processNewMessages();

      java.util.List userMessages = this.getCertainMessages(MessageFilter.getMessageTypeFilter(UserMessage.class), false);
      CoreLogger.log("saving user messages...", CoreLogger.LOG_NORMAL);
      java.util.Set savedKeysSet = new java.util.HashSet();
      java.util.Iterator it = userMessages.iterator();
      while(it.hasNext()) {
        UserMessage msg = (UserMessage)it.next();
 //       if (savedKeysSet.contains(msg.getPublicKey())==false) {
          savedKeysSet.add(msg.getPublicKey());
          fileOutputStream.write(Message.getBytesFromString(msg.getString()));
          fileOutputStream.write('\n');
  //      } else {
  //        this.messagesToBeIgnored.add(msg.getUniqueId());
   //     }
      }
      savedKeysSet.clear();

      CoreLogger.log("saving user comment messages...", CoreLogger.LOG_NORMAL);
      java.util.List userCommentMessages = this.getCertainMessages(MessageFilter.getMessageTypeFilter(UserCommentMessage.class), false);
      it = userCommentMessages.iterator();
      while(it.hasNext()) {
        UserCommentMessage msg = (UserCommentMessage)it.next();
        String key = msg.getOriginalPublicKey()+msg.getUserPublicKey();
     //   if (savedKeysSet.contains(key)==false) {
          savedKeysSet.add(key);
          fileOutputStream.write(Message.getBytesFromString(msg.getString()));
          fileOutputStream.write('\n');
     //   } else {
      //    this.messagesToBeIgnored.add(msg.getUniqueId());
      //  }
      }
      savedKeysSet.clear();

      CoreLogger.log("saving post messages...", CoreLogger.LOG_NORMAL);
      java.util.List postMessages = this.getCertainMessages(MessageFilter.getMessageTypeFilter(PostMessage.class), false);
      it = postMessages.iterator();
      while(it.hasNext()) {
        PostMessage msg = (PostMessage)it.next();
        fileOutputStream.write(Message.getBytesFromString(msg.getString()));
        fileOutputStream.write('\n');
      }
      savedKeysSet.clear();

      CoreLogger.log("saving archive messages...", CoreLogger.LOG_NORMAL);
      java.util.List archiveMessages = this.getCertainMessages(MessageFilter.getMessageTypeFilter(ArchiveMessage.class), true);
      it = archiveMessages.iterator();
      while(it.hasNext()) {
        ArchiveMessage msg = (ArchiveMessage)it.next();
        fileOutputStream.write(Message.getBytesFromString(msg.getString()));
        fileOutputStream.write('\n');
      }
      savedKeysSet.clear();

      CoreLogger.log("saving chess messages...", CoreLogger.LOG_NORMAL);
      java.util.List chessMessages = this.getCertainMessages(MessageFilter.getMessageTypeFilter(ChessMessage.class), true);
      it = chessMessages.iterator();
      while(it.hasNext()) {
        ChessMessage msg = (ChessMessage)it.next();
    //    if (savedKeysSet.contains(msg.getGameId())==false) {
          savedKeysSet.add(msg.getGameId());
          fileOutputStream.write(Message.getBytesFromString(msg.getString()));
          fileOutputStream.write('\n');
   //     } else {
   //       this.messagesToBeIgnored.add(msg.getUniqueId());
   //     }
      }
      fileOutputStream.close();
      CoreLogger.log("sucesfully wrote all messages to disk.", CoreLogger.LOG_NORMAL);
      new java.io.File(this.messagePoolFileName+".backup").delete();
    }
    catch (java.lang.Exception ex) {
      CoreLogger.log("failed to write message pool to disk:"+ex.getClass().getName()+": "+ex.getMessage(), CoreLogger.LOG_ERROR);
      ex.printStackTrace();
      throw new java.io.IOException(ex.getMessage());
    }


 /*  CoreLogger.log("saving ignore file to disk...", CoreLogger.LOG_WARNING);
   try {
      java.io.FileWriter fileWriter = new java.io.FileWriter(MessagePool.ignoredMessagesFileName);
      java.util.Iterator it = this.messagesToBeIgnored.iterator();
      while (it.hasNext()) {
        fileWriter.write((String)it.next());
        fileWriter.write("\n");
      }
    } catch (Exception ex) {
      CoreLogger.log("failed to write ignored messages file: "+ex.getClass()+": "+ex.getMessage(), CoreLogger.LOG_WARNING);
    }
*/
  }

  public synchronized void saveToDiskAlt() throws java.io.IOException  {
    CoreLogger.log("saving the message pool to disk...", CoreLogger.LOG_NORMAL);
    try {
      java.io.FileOutputStream fileOutputStream = new java.io.FileOutputStream(this.messagePoolFileName);
      this.processNewMessages();
      synchronized(this.allMessages) {
        java.util.List messagesList = new java.util.LinkedList(this.allMessages.values());
        java.util.Collections.sort(messagesList, Message.getDateComparator());
        java.util.Iterator it = messagesList.iterator();
        while(it.hasNext()) {
          Message msg = (Message)it.next();
          fileOutputStream.write(Message.getBytesFromString(msg.getString()));
          fileOutputStream.write('\n');
        }
      }
      fileOutputStream.close();
      CoreLogger.log("sucesfully wrote all messages to disk.", CoreLogger.LOG_NORMAL);
    } catch (java.lang.Exception ex) {
      CoreLogger.log("failed to write message pool to disk:"+ex.getClass().getName()+": "+ex.getMessage(), CoreLogger.LOG_ERROR);
      throw new java.io.IOException(ex.getMessage());
    }

  }

  boolean shouldMessageBeIgnored(String uniqueId) {
    return this.messagesToBeIgnored.contains(uniqueId);
  }

  boolean containsMessage(String uniqueId) {
    return this.allMessages.containsKey(uniqueId);
  }

  public synchronized PostMessage getPostMessage(String uniqueID) throws MessageNotReceivedException {
    Message msg = (Message)this.allMessages.get(uniqueID);
    if (msg==null) {
      throw new MessageNotReceivedException();
    }
    if ((msg instanceof PostMessage) == false) {
      throw new MessageNotReceivedException();
    }
    return ((PostMessage)msg);
  }

  public synchronized void replaceMessage(Message newMsg, String uri) {
    CoreLogger.log("forced insert of the original message "+newMsg+" from "+uri, CoreLogger.LOG_WARNING);
    synchronized(this.newMessages) {
      this.newMessages.put(newMsg.getUniqueId(), newMsg);
    }
  }

  public synchronized void addMessage(String sourceUri, final Message message) {

    if (this.incomingMessageFilter.acceptMessage(message)==false) {
      CoreLogger.log("message "+message.getUniqueId()+" from "+sourceUri+" was dropped by the incoming message filter.", CoreLogger.LOG_NORMAL);
      return;
    }
    synchronized(this.newMessages) {
      synchronized(this.allMessages) {
        if (this.allMessages.containsKey(message.getUniqueId())==false) {
          if (message.getOriginalUri().equals(sourceUri)) {
            CoreLogger.log("received the original of the new msg "+message.toShortString()+" from "+message.getSourceUri(), CoreLogger.LOG_NORMAL);
            if (FMBSettings.instance().autoForward) {
               this.forwardMessage(message);
            }
          } else {
            CoreLogger.log("received a copy of the new "+message.toShortString()+" from "+message.getSourceUri(), CoreLogger.LOG_NORMAL);
          }
        } else {
          CoreLogger.log("received another copy of "+message.toShortString()+" from "+message.getSourceUri(), CoreLogger.LOG_NORMAL);
          Message existingMessage = (Message)(this.allMessages.get(message.getUniqueId()));
          String sourceOfExisting = existingMessage.getSourceUri();
          if (existingMessage.equals(message)==false) {
            CoreLogger.log("the copy from "+sourceUri+" is not equal to the copy from "+sourceOfExisting, CoreLogger.LOG_NORMAL);
            if (existingMessage.contentEquals(message)==false) {
              CoreLogger.log("one of the messages has a faked content! ", CoreLogger.LOG_ERROR);
              freenetmessageboard.Main.getGUI().verifyMessage(existingMessage, message);
              return;
            }
            if (existingMessage.getSourceUri().equals(existingMessage.getOriginalUri()) && message.getSourceUri().equals(message.getOriginalUri())) {
              CoreLogger.log("this seems to be only a key collision problem, both message come from the original source and its content is equal", CoreLogger.LOG_NORMAL);
              return;
            }
            String existingBaseName=existingMessage.getOriginalUri().substring(0, existingMessage.getOriginalUri().lastIndexOf('/')+1);
            String newBaseName=message.getOriginalUri().substring(0, message.getOriginalUri().lastIndexOf('/')+1);
            if (existingBaseName.equals(newBaseName)) {
              CoreLogger.log("this seems to be only a key collision problem, the content is equal and the original source is on the same channel", CoreLogger.LOG_NORMAL);
              return;
            }

            freenetmessageboard.Main.getGUI().verifyMessage(existingMessage, message);
            return;
          }
          if (message.getSourceUri().equals(existingMessage.getSourceUri())) {
            CoreLogger.log("i already have the version from "+message.getSourceUri()+", keeping it...", CoreLogger.LOG_NORMAL);
            return;
          }
          if (message.getOriginalUri().equals(sourceUri)==false){
            CoreLogger.log("don't need the copy from "+message.getSourceUri()+", keep the one from "+existingMessage.getSourceUri(), CoreLogger.LOG_NORMAL);
            return;
          } else {
            if (FMBSettings.instance().autoForward) {
              this.forwardMessage(message);
            }
            CoreLogger.log("the new message is from the original source ("+message.getSourceUri()+"), the existing only from "+existingMessage.getSourceUri(), CoreLogger.LOG_NORMAL );
          }
        }
        CoreLogger.log("thread is adding a new message...", CoreLogger.LOG_INFO);
        this.newMessages.put(message.getUniqueId(), message);
      }
    }
  }

  private void forwardMessage(final Message message) {
    if (message.getOriginalPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
      return;
    }
    Thread helpThread = new Thread("forwarding thread") {
      public void run() {
        CoreLogger.log("autoforwarding the message "+message.getUniqueId(), CoreLogger.LOG_WARNING);
        MessageGateway.instance().sendMessageOnPersonalChannel(message);
      }
    };
    helpThread.start();
  }

  public Message getLatestMessageFromUser(String publicKey) {
    return (Message)this.lastMessageFromUser.get(publicKey);
  }

  public synchronized void processNewMessages() {
    if (this.newMessages.size()>0) {
      CoreLogger.log(this.newMessages.size()+" messages are new in the message pool", CoreLogger.LOG_NORMAL);
    }
    CoreLogger.log("thread wants to enter the monitor...", CoreLogger.LOG_INFO);
    synchronized (this.newMessages) {
      CoreLogger.log("thread is processing the new messages", CoreLogger.LOG_INFO);
      java.util.Iterator it = this.newMessages.keySet().iterator();
      while (it.hasNext()) {
        String uniqueId = (String)it.next();
        Message msg = (Message)this.newMessages.get(uniqueId);
        synchronized(this.allMessages) {
          this.allMessages.put(uniqueId, msg);
        }

        if (this.lastMessageFromUser.containsKey(msg.getOriginalPublicKey())) {
          Message existingMsg = (Message)this.lastMessageFromUser.get(msg.getOriginalPublicKey());
          if (msg.getDate().compareTo(existingMsg.getDate())>0) {
            this.lastMessageFromUser.put(msg.getOriginalPublicKey(), msg);
          }
        } else {
          this.lastMessageFromUser.put(msg.getOriginalPublicKey(), msg);
        }


        java.util.Iterator listenerIt = this.messageArrivedListener.keySet().iterator();
        while (listenerIt.hasNext()) {
          MessageArrivedListener listener = (MessageArrivedListener)listenerIt.next();
          MessageFilter filter = (MessageFilter)this.messageArrivedListener.get(listener);
          if (filter.acceptMessage(msg)) {
            CoreLogger.log("telling "+listener.getClass().getName()+" that there is a new message "+msg.toShortString(), CoreLogger.LOG_INFO);
            listener.messageArrived(msg);
          }
        }


        try {
          ContactList.instance().getContactInformationOfPublicKey(msg.getOriginalPublicKey()).setTimeOfLastActivity(msg.getDate());
        } catch (NoSuchContactException e) {
          CoreLogger.log("failed to update activityy time:here is no contact with key "+msg.getOriginalPublicKey()+" in the contact list!", CoreLogger.LOG_NORMAL );
        }

        String baseName = msg.getOriginalUri().substring(0, msg.getOriginalUri().lastIndexOf('/')+1);
        if (ChannelInfo.instanceExists(baseName)) {
          ChannelInfo info = ChannelInfo.getInstance(baseName);
          info.heardOfIndex(MessageGateway.instance().getIndexFromUri(msg.getOriginalUri()));
        }
      }
      this.newMessages.clear();
    }
    CoreLogger.log("thread left the monitor", CoreLogger.LOG_INFO);
    CoreLogger.log("the message pool contains "+this.allMessages.size()+" unique messages", CoreLogger.LOG_INFO);
  }

  public Message[] getUsefulMessages() {
    CoreLogger.log("choosing important messages from the message pool...", CoreLogger.LOG_NORMAL);
    Message[] msgs = new Message[50];
    synchronized(this.allMessages) {
      if (this.allMessages.size()<50) {
        msgs = new Message[this.allMessages.size()];
      }
      java.util.SortedSet set = new java.util.TreeSet(Message.getUsefulorBroadcoastingComparator());
      set.addAll(this.allMessages.values());
      java.util.Iterator it = set.iterator();
      int i=0;
      while (it.hasNext() && i<msgs.length) {
        msgs[i]=(Message)it.next();
        i++;
      }
    }
    CoreLogger.log("returning "+msgs.length+" useful messages", CoreLogger.LOG_NORMAL);
    return msgs;
  }

  public void run() {
    CoreLogger.log("the message pool is beginning to process messages.", CoreLogger.LOG_NORMAL);
    while(true) {
      this.processNewMessages();
      try {
        Thread.sleep(200);
      }
      catch (InterruptedException ex) {
      }
    }
  }

  void addMessageArrivedListener(MessageArrivedListener callback, MessageFilter filter) {
    synchronized(this.messageArrivedListener) {
      this.messageArrivedListener.put(callback, filter);
    }
  }

  public static synchronized MessagePool instance() {
    if (MessagePool.instance==null) {
      try {
        MessagePool.instance=MessagePool.readMessagePoolFromDisk();
      } catch (java.io.IOException ex) {
        CoreLogger.log("creating empty message pool...", CoreLogger.LOG_WARNING);
        MessagePool.instance=new MessagePool();
      }
    }
    return MessagePool.instance;
  }
}

interface MessageArrivedListener  {
  public void messageArrived(Message message);
}