package freenetmessageboard.core;

import freenetmessageboard.fcpinterface.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class MessageGateway extends Thread implements FCPRequestCallback, FCPInsertCallback {

  private static MessageGateway instance;

  final static int maxInsertSize=32000;
  private static long flushTime=1800; //seconds

  private static java.util.Date currentListeningDate = new java.util.Date();

  public static java.text.DateFormat uriDateFormat;
  private long timeOfLastInsert = new java.util.Date().getTime();

  private final static String publicChannelBaseKSKprefix = "KSK@fmb/announcements";

  private static java.util.Map currentSlotForInsertsMap = new java.util.HashMap();

  static {
    MessageGateway.uriDateFormat=new java.text.SimpleDateFormat("yyyy.MM.dd");
    MessageGateway.uriDateFormat.setTimeZone(java.util.TimeZone.getTimeZone("GMT"));
  }

  private java.util.List queuedMessages = new java.util.LinkedList();
  private java.util.List insertRetryQueueUris = new java.util.LinkedList();
  private java.util.List insertNextSlotUris = new java.util.LinkedList();

  private java.util.Map activeInsertMessagesListMap = new java.util.HashMap();
  private java.util.Map activeInsertsBytes = new java.util.HashMap();
  private java.util.Map succesfullyInserted = new java.util.HashMap();
  private java.util.List keyCollisionInserts = new java.util.LinkedList();

//  private StringBuffer personalChannelMessageBuffer = new StringBuffer(this.maxInsertSize);

  private byte[] personalChannelInsertBuffer = new byte[this.maxInsertSize];
  private int insertBufferIndex;

  private java.util.Map activeRequestInfos = new java.util.HashMap();
  private java.util.List requestRetryQueueUris = new java.util.LinkedList();

  private java.util.HashMap activeChannelInfos = new java.util.HashMap();

  private java.util.List channelsToBeContinued = new java.util.ArrayList();
  private java.util.List channelToBeStopped = new java.util.ArrayList();

  private java.util.List spammedUris = new java.util.LinkedList();

  private boolean haveAnnouncedToday=false;

  private MessageGateway() {
    this.setName("MessageGateway");
  }

  synchronized void sendMessageOnPublicAnnouncementChannel(Message message) {
    Message[] msgs = new Message[1];
    msgs[0]=message;
    this.sendMessagesOnPublicAnnouncementChannel(msgs);
  }

  synchronized void sendMessagesOnPublicAnnouncementChannel(Message[] messages) {
    String uri = MessageGateway.constructNextPublicAnnouncementChannelUriForInsert(MessageGateway.getCurrentDate());
    MessageGateway.increaseSlotIndexForInsert(uri);
    StringBuffer buf = new StringBuffer(1000);
    java.util.List msgList = new java.util.LinkedList();
    for (int i=0; i<messages.length; i++) {
      if (messages[i] instanceof UserMessage) {
        CoreLogger.log("a "+messages[i].getClass().getName()+" is being inserted to "+uri, CoreLogger.LOG_INFO);
        if (messages[i].getOriginalUri().equals("n/a")) {
          messages[i].setOriginalUri(uri);
        }
        buf.append(messages[i].getString());
        buf.append('\n');
        msgList.add(messages[i]);
      }
    }
    byte[] dataBytes = Message.getBytesFromString(buf.toString());
    String msgString = buf.toString();
    FCPFacade.instance().startFreenetInsert(this, uri, new byte[0], dataBytes, FreenetNetworkSettings.instance().regularInsertHTL, false);
    this.activeInsertMessagesListMap.put(uri, msgList);
    this.activeInsertsBytes.put(uri, dataBytes);
    ChannelInfo channelInfo = ChannelInfo.getInstance(this.constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate()));
    channelInfo.setStatusString("inserting announcement...");
  }

  public static java.util.Date getCurrentDate() {
    return MessageGateway.currentListeningDate;
  }

  synchronized void listenOnChannel(String baseName) {
    CoreLogger.log("listening on channel "+baseName+"...", CoreLogger.LOG_NORMAL);
    ChannelInfo channelInfo = ChannelInfo.getInstance(baseName);
    String uri = channelInfo.getNextUri();
    channelInfo.setStatusString("channel queued for listening...");
    this.activeChannelInfos.put(uri, channelInfo);
    int htl =channelInfo.getHTLForCurrentRequest();
    this.requestMessagesFromUri(uri, htl);
  }


  public synchronized void startListeningOnPublicAnnouncementChannel() {
    String uri = this.constructNextPublicAnnouncementChannelUriForInsert(MessageGateway.getCurrentDate());
    this.listenOnChannel(uri.substring(0, uri.lastIndexOf('/')+1));
  }


  public synchronized void startListeningOnPersonalChannel(String publicKey) {
    String baseName = this.constructPersonalChannelBaseName(publicKey, MessageGateway.getCurrentDate());
    if (this.isListeningOnPersonalChannel(publicKey)) {
      CoreLogger.log("you are already listening on the channel "+baseName, CoreLogger.LOG_WARNING);
      return;
    }
    this.listenOnChannel(baseName);
  }

  boolean isListeningOnPersonalChannel(String publicKey) {
    String baseName = this.constructPersonalChannelBaseName(publicKey, MessageGateway.getCurrentDate());
    ChannelInfo channelInfo = ChannelInfo.getInstance(baseName);
    return this.activeChannelInfos.containsValue(channelInfo);
  }

  public synchronized void stopListeningOnPublicAnnouncementChannel() {
    String baseName=this.constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate());
    CoreLogger.log("listening on the public announcement channel will be stopped soon", CoreLogger.LOG_NORMAL);
    this.stopListeningOnChannel(baseName);
  }

  public synchronized void stopListeningOnPersonalChannel(String publicKey) {

    String baseName=this.constructPersonalChannelBaseName(publicKey, MessageGateway.getCurrentDate());
    CoreLogger.log("listening on "+baseName+" will be stopped soon", CoreLogger.LOG_NORMAL);
    this.stopListeningOnChannel(baseName);
  }

  private void stopListeningOnChannel(String baseName) {
    synchronized(this.channelToBeStopped) {
      this.channelToBeStopped.add(baseName);
    }
    ChannelInfo info = ChannelInfo.getInstance(baseName);
    info.setStatusString("listening is going to be stopped...");
  }

  private synchronized void requestMessagesFromUri(String uri, int htl) {
    CoreLogger.log("starting request of "+uri+" with htl "+htl+"...", CoreLogger.LOG_INFO);
    RequestInfo info = new RequestInfo(htl);
    this.activeRequestInfos.put(uri, info);
    FCPFacade.instance().startFreenetRequest(this, uri,htl,false);
  }

  synchronized void requestMessagesFromUri(String uri) {
    this.requestMessagesFromUri(uri, FreenetNetworkSettings.instance().regularRequestHTL);
  }

  public synchronized void sendMessagesOnPersonalChannel(Message[] msgs) {
    for (int i=0; i<msgs.length; i++) {
      this.sendMessageOnPersonalChannel(msgs[i]);
    }
  }


  public synchronized void sendMessageOnPersonalChannel(Message message) {
    if (FMBSettings.instance().autoForward) {
      this.flushTime=300;
    }
    if (this.haveAnnouncedToday==false) {
      CoreLogger.log("the first message is being sent, send announcements first...", CoreLogger.LOG_NORMAL);
      this.haveAnnouncedToday=true;
      MessageGateway.instance().sendMessagesOnPersonalChannel(ContactList.instance().getUserMessagesToBeAnnounced());
    }
    message.increaseSentCounter();
    CoreLogger.log("a "+message.getClass().getName()+" was queued for insert", CoreLogger.LOG_DEBUG);
    String msgString = message.getString();
    if (this.insertBufferIndex==0) {
      this.timeOfLastInsert=new java.util.Date().getTime();
    }
    byte[] newMsgBytes = Message.getBytesFromString(msgString+"\n");
    if (this.insertBufferIndex+newMsgBytes.length>this.maxInsertSize) {
      this.flushPersonalChannelMessageBuffer();
    }
    if (message.getOriginalUri().equals("n/a")) {
      String uri = MessageGateway.constructNextPersonalChannelURIForInsert(PersonalInfo.instance().getPrivateKey(), MessageGateway.getCurrentDate(), true);
      message.setOriginalUri(uri);
      msgString = message.getString();
      newMsgBytes = Message.getBytesFromString(msgString+"\n");
    }



    if (message instanceof UserMessage || message instanceof UserCommentMessage) {
      MessagePool.instance().addMessage("not succesfully inserted yet", message);
    }
    CoreLogger.log("adding "+newMsgBytes.length+" to the insert buffer at pos "+this.insertBufferIndex+", total length is "+this.personalChannelInsertBuffer.length, CoreLogger.LOG_NORMAL);
    System.arraycopy(newMsgBytes, 0, this.personalChannelInsertBuffer, this.insertBufferIndex, newMsgBytes.length);
    this.insertBufferIndex+=newMsgBytes.length;
    this.queuedMessages.add(message);
    freenetmessageboard.Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
  }

  public synchronized String getSlotInfoStringForMyPersonalChannel() {
    StringBuffer buf = new StringBuffer(30);
    char[] infoChars = new char[this.getNextIndexForInsert(this.constructPersonalChannelBaseName(PersonalInfo.instance().getPrivateKey(), MessageGateway.getCurrentDate()))];
    for (int i=0; i<infoChars.length; i++) {
      infoChars[i]=' ';
    }
    CoreLogger.log("creating slotinfo string for personal channel (max. "+infoChars.length+" chars)", CoreLogger.LOG_INFO);
    int highestIndex=-1;
    synchronized (this.activeInsertMessagesListMap) {
      java.util.Iterator it = this.activeInsertMessagesListMap.keySet().iterator();
      while (it.hasNext()) {
        String insertingUri = (String)it.next();
        CoreLogger.log("checking active insert "+insertingUri, CoreLogger.LOG_INFO);
        if (Message.isUriFromKey(insertingUri, PersonalInfo.instance().getPrivateKey())) {
          int index = MessageGateway.getIndexFromUri(insertingUri);
          CoreLogger.log("currently inserting on index "+index, CoreLogger.LOG_INFO);
          infoChars[index]='I';
          highestIndex=index;
        }
      }
    }

    synchronized(this.succesfullyInserted) {
      java.util.Iterator it = this.succesfullyInserted.keySet().iterator();
      while (it.hasNext()) {
        String insertedUri = (String)(it.next());
        CoreLogger.log("checking inserted "+insertedUri, CoreLogger.LOG_INFO);
        if (Message.isUriFromKey(insertedUri, PersonalInfo.instance().getPublicKey())) {
          int index = MessageGateway.getIndexFromUri(insertedUri);
          CoreLogger.log("succesfully inserted on index "+index, CoreLogger.LOG_INFO);
          infoChars[index]='X';
          if (index>highestIndex) {
            highestIndex=index;
          }
        }
      }
    }

    synchronized(this.keyCollisionInserts) {
      java.util.Iterator it = this.keyCollisionInserts.iterator();
      while (it.hasNext()) {
        String insertingUri = (String)it.next();
        CoreLogger.log("checking key collision "+insertingUri, CoreLogger.LOG_INFO);
        if (Message.isUriFromKey(insertingUri,PersonalInfo.instance().getPrivateKey())) {
          int index = MessageGateway.getIndexFromUri(insertingUri);
          CoreLogger.log("key collision on insert of "+index, CoreLogger.LOG_INFO);
          infoChars[index]='K';
          if (index>highestIndex) {
            highestIndex=index;
          }
        }
      }
    }

    for (int i=0; i<=highestIndex; i++) {
      if (i>infoChars.length) {
        CoreLogger.log("no space for char "+i, CoreLogger.LOG_INFO);
        continue;
      }
      buf.append(infoChars[i]);
    }
    CoreLogger.log("resulting slot info string: "+buf.toString(), CoreLogger.LOG_INFO);
    String s = buf.toString();
    if (s.length()>30) {
      return "..."+s.substring(s.length()-30);
    }
    return s;
  }

  public byte[] getUsefulBytesToStuffInsert(int length) {
    CoreLogger.log("trying to find "+length+" useful bytes to stuff the insert...", CoreLogger.LOG_NORMAL);
    Message[] msgs = MessagePool.instance().getUsefulMessages();
    byte[] bytes = new byte[length];
    int currentIndex=0;
    int includedMsgs=0;

    for (int i=0; i<msgs.length; i++) {
      if (MessageFilter.originalMessagesOnlyFilter().acceptMessage(msgs[i])) {
        byte[] msgBytes = Message.getBytesFromString(msgs[i].getString()+"\n");

        if (msgBytes.length<=bytes.length-currentIndex) {
          CoreLogger.log("including "+msgs[i].toShortString()+": "+msgs[i].getSentCounter()+" sends, "+msgs[i].getRetrievedCounter()+" retrieved "+msgs[i].getDate(), CoreLogger.LOG_NORMAL);
          msgs[i].increaseSentCounter();
          System.arraycopy(msgBytes, 0, bytes, currentIndex, msgBytes.length);
          currentIndex+=msgBytes.length;
          includedMsgs++;
        }
      }
    }
    CoreLogger.log("filled up "+length+" bytes with "+includedMsgs+" usefull messages!", CoreLogger.LOG_NORMAL);
    return bytes;
  }

  public boolean areThereActiveInserts() {
    if (this.insertBufferIndex!=0) {
      return true;
    }
    if (this.activeInsertMessagesListMap.size()>0) {
      return true;
    }
    return false;
  }

  public synchronized void flushPersonalChannelMessageBuffer() {
    if (this.insertBufferIndex==0) return;
    String uri = MessageGateway.constructNextPersonalChannelURIForInsert(PersonalInfo.instance().getPrivateKey(), MessageGateway.getCurrentDate(), false);
    this.increaseSlotIndexForInsert(uri);
    CoreLogger.log("inserting message buffer to "+uri, CoreLogger.LOG_NORMAL);
    byte[] metaBytes = new byte[0];
//    String message = this.personalChannelMessageBuffer.toString();
 //   byte[] msgBytes = Message.getBytesFromString(message);
 //   this.personalChannelMessageBuffer = new StringBuffer(this.maxInsertSize);


    byte[] usefullBytes = this.getUsefulBytesToStuffInsert(this.personalChannelInsertBuffer.length-this.insertBufferIndex);

    CoreLogger.log("adding "+usefullBytes.length+" to the insert buffer at pos "+this.insertBufferIndex+", total length is "+this.personalChannelInsertBuffer.length, CoreLogger.LOG_NORMAL);
    System.arraycopy(usefullBytes, 0, this.personalChannelInsertBuffer, this.insertBufferIndex, usefullBytes.length);

    FCPFacade.instance().startFreenetInsert(this, uri, new byte[0], this.personalChannelInsertBuffer, FreenetNetworkSettings.instance().regularInsertHTL, false);
    this.activeInsertMessagesListMap.put(uri, this.queuedMessages);
    CoreLogger.log("remembering "+usefullBytes.length+" of stuffdata for uri "+uri, CoreLogger.LOG_NORMAL);
    this.activeInsertsBytes.put(uri, usefullBytes);
    this.personalChannelInsertBuffer=new byte[this.maxInsertSize];
    this.insertBufferIndex=0;
    freenetmessageboard.Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
    this.queuedMessages=new java.util.LinkedList();
    this.timeOfLastInsert=new java.util.Date().getTime();
  }

  private void startRetries() {

    synchronized(this.insertRetryQueueUris) {
      java.util.Iterator it = this.insertRetryQueueUris.iterator();
      while (it.hasNext()) {
        this.retryInsert((String)it.next(), false);
      }
      this.insertRetryQueueUris.clear();
    }

    CoreLogger.log("starting retries on next slots...", CoreLogger.LOG_DEBUG);
    synchronized(this.insertNextSlotUris) {
      java.util.Iterator it = this.insertNextSlotUris.iterator();
      while (it.hasNext()) {
        String uri = (String)it.next();
        if (uri.startsWith(this.constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate()))) {
          ChannelInfo channelInfo = ChannelInfo.getInstance(uri.substring(0,uri.lastIndexOf('/')+1));
          channelInfo.setStatusString("sending announcement on slot "+this.getIndexFromUri(uri));
        }
        CoreLogger.log("trying to retry "+uri, CoreLogger.LOG_INFO);
        this.retryInsert(uri, true);
        CoreLogger.log("returned from retryInsert", CoreLogger.LOG_DEBUG);
      }
      this.insertNextSlotUris.clear();
    }

    CoreLogger.log("finished starting retries on next slots", CoreLogger.LOG_DEBUG);
    synchronized(this.requestRetryQueueUris) {
      java.util.Iterator it = this.requestRetryQueueUris.iterator();
      while (it.hasNext()) {
        String uri = (String)it.next();
        RequestInfo requestInfo;
        synchronized (this.activeRequestInfos) {
          requestInfo = (RequestInfo)this.activeRequestInfos.get(uri);
        }
        CoreLogger.log("starting to retry requesting of "+uri+" with htl "+requestInfo.htl, CoreLogger.LOG_INFO);
        FCPFacade.instance().startFreenetRequest(this, uri, requestInfo.htl, false);
      }
      this.requestRetryQueueUris.clear();
    }
  }

  private void startContinuedChannelRequests() {
    CoreLogger.log("Continuing channel requests...", CoreLogger.LOG_INFO);
    synchronized(this.channelsToBeContinued) {
      synchronized(this.channelToBeStopped) {
        CoreLogger.log("Are there channels to be stopped?", CoreLogger.LOG_INFO);
        java.util.Iterator i = this.channelToBeStopped.iterator();
        while(i.hasNext()) {
          CoreLogger.log("...the channel "+i.next()+" should be stopped!", CoreLogger.LOG_INFO);
        }
        if (this.channelToBeStopped.size()==0) {
          CoreLogger.log("...no there aren't", CoreLogger.LOG_INFO);
        }

        java.util.Iterator it = this.channelsToBeContinued.iterator();
        java.util.List channelsWhichWereStopped = new java.util.ArrayList();
        while(it.hasNext()) {
          ChannelInfo channelInfo = (ChannelInfo)it.next();
          CoreLogger.log("checking if channel "+channelInfo.baseName+" should be stopped..", CoreLogger.LOG_INFO);
          if (this.channelToBeStopped.contains(channelInfo.baseName)) {
            CoreLogger.log("yes it should be stopped", CoreLogger.LOG_INFO);
            channelsWhichWereStopped.add(channelInfo.baseName);
            channelInfo.setStatusString("listening was stopped");
          } else {
            CoreLogger.log("no, you can continue...", CoreLogger.LOG_INFO);
            this.listenOnChannel(channelInfo.baseName);
          }
        }
        java.util.Iterator ite = channelsWhichWereStopped.iterator();
        while(ite.hasNext()) {
          this.channelToBeStopped.remove(ite.next());
        }
      }
      this.channelsToBeContinued.clear();
    }
  }

  public void run() {
    CoreLogger.log("the message gateway was started", CoreLogger.LOG_NORMAL);
    while(true) {
      this.startRetries();
      this.startContinuedChannelRequests();
      java.util.Date now = new java.util.Date();
      long timeSinceLustFlush = now.getTime()-this.timeOfLastInsert;
      if (timeSinceLustFlush>this.flushTime*1000 && this.insertBufferIndex>0) {
        CoreLogger.log("flushing message buffer because it was idle for "+this.flushTime+" seconds", CoreLogger.LOG_NORMAL);
        this.flushPersonalChannelMessageBuffer();
      }
      try {
        Thread.sleep(300);
      }
      catch (InterruptedException ex) {
      }
    }
  }

  public static synchronized MessageGateway instance() {
    if (MessageGateway.instance==null) {
      MessageGateway.instance=new MessageGateway();
      MessageGateway.instance.start();
    }
    return MessageGateway.instance;
  }

  private static synchronized int getNextIndexForInsert(String baseName) {
    Integer integer = (Integer)MessageGateway.currentSlotForInsertsMap.get(baseName);
    int i;
    if (integer==null) {
      i=0;
    } else {
      i=integer.intValue();
    }
    MessageGateway.currentSlotForInsertsMap.put(baseName, new Integer(i));
    return i;
  }

  private static String constructNextPublicAnnouncementChannelUriForInsert(java.util.Date date) {
    StringBuffer buf = new StringBuffer(40);
    buf.append(MessageGateway.constructPublicAnnouncementChannelBaseName(date));
    buf.append(MessageGateway.getNextIndexForInsert(buf.toString()));
    return buf.toString();
  }

  public static String constructPersonalChannelBaseName(String publicKey, java.util.Date date) {
    StringBuffer buf = new StringBuffer(80);
    buf.append("SSK@");
    buf.append(publicKey);
    buf.append("/fmb/");
    buf.append(MessageGateway.uriDateFormat.format(date));
    buf.append("/");
    return buf.toString();
  }


  static String constructPublicAnnouncementChannelBaseName(java.util.Date date) {
    StringBuffer buf = new StringBuffer(20);
    buf.append(MessageGateway.publicChannelBaseKSKprefix);
    buf.append("/");
    buf.append(MessageGateway.uriDateFormat.format(date));
    buf.append("/");
    return buf.toString();
  }

  void addSpammedUri(String uri) {
    CoreLogger.log("the data from "+uri+" is no valid fmb data, it is propably being spammed!", CoreLogger.LOG_WARNING);
    synchronized(this.spammedUris) {
      if (this.spammedUris.contains(uri)==false) {
        this.spammedUris.add(uri);
      }
    }
  }

  boolean isUriSpammed(String uri) {
    synchronized(this.spammedUris) {
      return this.spammedUris.contains(uri);
    }
  }

  private static String constructNextPersonalChannelURIForInsert(String key, java.util.Date date, boolean returnPublicUri) {
    StringBuffer buf = new StringBuffer(80);
    String baseName = MessageGateway.constructPersonalChannelBaseName(key, date);
    int nextIndex = MessageGateway.getNextIndexForInsert(baseName);
    if (returnPublicUri) {
      baseName = MessageGateway.constructPersonalChannelBaseName(PersonalInfo.instance().getPublicKey(), date);
    }
    return baseName+nextIndex;
  }

  public void insertSuccesfull(String uri, InsertInfo insertInfo) {
    java.util.List insertedMessages = (java.util.List)this.activeInsertMessagesListMap.remove(uri);
    this.activeInsertsBytes.remove(uri);
    CoreLogger.log("sucesfully inserted "+insertedMessages.size()+" messages to "+insertInfo.getFinalUri(), CoreLogger.LOG_NORMAL);
    java.util.Iterator it = insertedMessages.iterator();
     boolean isFromMyOwnPersonalChannel=Message.isUriFromKey(uri, PersonalInfo.instance().getPrivateKey());
    if (isFromMyOwnPersonalChannel) {
      uri = PersonalInfo.instance().privateToPublicUri(uri);
    }
    this.succesfullyInserted.put(uri, insertInfo);
    while(it.hasNext()) {
      Message msg = (Message)it.next();
      if ((msg instanceof UserMessage) && isFromMyOwnPersonalChannel && msg.getOriginalPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
        CoreLogger.log("succesfull inserted my announcement to my personal channel, inserting a copy on the public announcement channel", CoreLogger.LOG_NORMAL );
        this.sendMessagesOnPublicAnnouncementChannel((Message[])insertedMessages.toArray(new Message[insertedMessages.size()]));
      }
      if (isFromMyOwnPersonalChannel) {
        if (msg.getOriginalPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
          msg.setSource(uri);
          MessagePool.instance().addMessage(uri, msg);
        }
      }
    }
    String publicAnnouncementChannelBasename=this.constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate());
    if (uri.startsWith(publicAnnouncementChannelBasename)) {
      freenetmessageboard.Main.getGUI().setAnnouncementChannelStatusString("announcement succesfull", ChannelInfo.getInstance(publicAnnouncementChannelBasename).getSlotInfoString());
      freenetmessageboard.Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
    } else {
      freenetmessageboard.Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
    }
  }

  private void retryInsert(String uri, boolean increaseIndex) {
    CoreLogger.log("retrying insert of "+uri, CoreLogger.LOG_NORMAL);
    String oldUri=uri;
    java.util.List messagesToRety = (java.util.List)this.activeInsertMessagesListMap.remove(uri);
    CoreLogger.log("looking for stuffdata of uri "+uri, CoreLogger.LOG_NORMAL);
    byte[] usefullBytes = (byte[])this.activeInsertsBytes.remove(uri);
    if (usefullBytes==null) {
      CoreLogger.log("no stuffdata found for uri "+uri, CoreLogger.LOG_NORMAL);
    } else {
      CoreLogger.log("found "+usefullBytes.length+" of stuffdata for uri "+uri, CoreLogger.LOG_NORMAL);
    }
    StringBuffer msgBuf = new StringBuffer(this.maxInsertSize);
    java.util.Iterator it = messagesToRety.iterator();
    if (increaseIndex) {
      CoreLogger.log("increasing index of uri "+uri, CoreLogger.LOG_INFO);
      uri = MessageGateway.getCurrentSlotUriForInsert(oldUri);
      MessageGateway.increaseSlotIndexForInsert(oldUri);
      CoreLogger.log("increased index of "+oldUri+" to "+uri, CoreLogger.LOG_NORMAL);
    }
    CoreLogger.log("updating the original uri of "+messagesToRety.size()+" messages...", CoreLogger.LOG_INFO);
    while(it.hasNext()) {
      Message msg = ((Message)it.next());
      if (increaseIndex) {
        String origUri = msg.getOriginalUri();
        if (origUri.equals(oldUri)) {
          msg.setOriginalUri(uri);
        }
        if (msg.getOriginalPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
          if (origUri.equals(PersonalInfo.instance().privateToPublicUri(oldUri))) {
            msg.setOriginalUri(PersonalInfo.instance().privateToPublicUri(uri));
          }
        }
        CoreLogger.log("the original uri of the "+msg.getMessageType()+" message was set to "+msg.getOriginalUri() , CoreLogger.LOG_INFO);
      }
      msgBuf.append(msg.getString());
      msgBuf.append('\n');
    }

    byte[] metaBytes = new byte[0];
    String message = msgBuf.toString();
    byte[] msgBytes = Message.getBytesFromString(message);

    byte[] dataBytes;

    if (uri.startsWith("SSK@"+PersonalInfo.instance().getPrivateKey())) {
      dataBytes= new byte[msgBytes.length+usefullBytes.length];
      System.arraycopy(msgBytes, 0, dataBytes, 0, msgBytes.length);
      System.arraycopy(usefullBytes, 0, dataBytes, msgBytes.length, usefullBytes.length);
    } else {
      dataBytes=msgBytes;
    }

    CoreLogger.log("restarting insert to "+uri, CoreLogger.LOG_WARNING);
    FCPFacade.instance().startFreenetInsert(this, uri, new byte[0], dataBytes, FreenetNetworkSettings.instance().regularInsertHTL, false);
    CoreLogger.log("returned from FCPFacade.", CoreLogger.LOG_INFO);
    this.activeInsertMessagesListMap.put(uri, messagesToRety);
    if (usefullBytes!=null) {
      this.activeInsertsBytes.put(uri, usefullBytes);
    }
    freenetmessageboard.Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());

    CoreLogger.log("returning from retryInsert", CoreLogger.LOG_INFO);
  }

  private void addToInsertNextSlotQueue(String uri) {
    CoreLogger.log("inserting "+uri+" to next slot queue...", CoreLogger.LOG_INFO);
    synchronized (this.insertNextSlotUris) {
      this.keyCollisionInserts.add(uri);
      this.insertNextSlotUris.add(uri);
      CoreLogger.log("Queuing "+uri+" done.", CoreLogger.LOG_INFO);
    }
  }

  private void addToInsertRetryQueue(String uri) {
    synchronized (this.insertRetryQueueUris) {
      this.insertRetryQueueUris.add(uri);
    }
  }

  static int getIndexFromUri(String uri) {
    String indexString = uri.substring(uri.lastIndexOf('/')+1);
    return Integer.parseInt(indexString);
  }

  private static void increaseSlotIndexForInsert(String uri) {
    String baseName = uri.substring(0, uri.lastIndexOf('/')+1);
    Integer integer = (Integer)MessageGateway.currentSlotForInsertsMap.get(baseName);
    int i;
    if (integer==null) {
      i=0;
    } else {
      i=integer.intValue();
    }
    i++;
    MessageGateway.currentSlotForInsertsMap.put(baseName, new Integer(i));
  }

  int getCurrentPublicAnnouncementInsertIndex() {
    synchronized(this.activeInsertMessagesListMap) {
      java.util.Iterator it = this.activeInsertMessagesListMap.keySet().iterator();
      while(it.hasNext()) {
        String insertingUri = (String)it.next();
        if (insertingUri.startsWith(this.constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate()))) {
          return this.getIndexFromUri(insertingUri);
        }
      }
    }
    return -1;
  }

  private static String getCurrentSlotUriForInsert(String uri) {
    String baseName = uri.substring(0, uri.lastIndexOf('/')+1);
    int index = MessageGateway.getNextIndexForInsert(baseName);
    return baseName+index;
  }

  public void insertFailedWithKeyCollision(String uri) {
    CoreLogger.log("the insert of "+uri+" failed with Key Collision, retrying with increased index...", CoreLogger.LOG_NORMAL);
    this.addToInsertNextSlotQueue(uri);
    if (Message.isUriFromKey(uri, PersonalInfo.instance().getPrivateKey())) {
      CoreLogger.log("key collision on the personal channel, start requesting "+PersonalInfo.instance().privateToPublicUri(uri), CoreLogger.LOG_NORMAL);
      this.requestMessagesFromUri(PersonalInfo.instance().privateToPublicUri(uri), 0);
    }
    freenetmessageboard.Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
  }

  public void insertFailedWithRouteNotFound(String uri) {
    CoreLogger.log("the insert of "+uri+" failed with Route not Found", CoreLogger.LOG_WARNING);
    this.addToInsertRetryQueue(uri);
    freenetmessageboard.Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
  }

  public void insertFailedBadly(String uri, String info) {
    CoreLogger.log("the insert of "+uri+" failed badly: "+info, CoreLogger.LOG_ERROR);
    this.addToInsertRetryQueue(uri);
    freenetmessageboard.Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
  }

  public void requestSuccesfull(String uri, RequestedData data) {
    CoreLogger.log("request of "+uri+" was succesfull", CoreLogger.LOG_NORMAL);
    this.activeRequestInfos.remove(uri);
    if (this.activeChannelInfos.containsKey(uri)) {
      CoreLogger.log("the request of "+uri+" was a channel request...", CoreLogger.LOG_INFO);
      ChannelInfo channelInfo = (ChannelInfo)(this.activeChannelInfos.get(uri));
      channelInfo.receivedIndex(this.getIndexFromUri(uri));
      boolean continueChannel=true;
      synchronized(this.channelToBeStopped) {
        if (this.channelToBeStopped.contains(channelInfo.baseName)) {
          CoreLogger.log("requests on channel "+channelInfo.baseName+" are stopped.", CoreLogger.LOG_NORMAL);
          channelInfo.setStatusString("stopped listening");
          continueChannel=false;
        }
      }
      if (continueChannel) {
        CoreLogger.log("requests on channel "+channelInfo.baseName+" will be continued.", CoreLogger.LOG_INFO);
        synchronized(this.channelsToBeContinued) {
          this.channelsToBeContinued.add(channelInfo);
        }
      }
      this.activeChannelInfos.remove(uri);
    }
    Message[] messages = Message.parseMultipleMessageString(Message.getStringFromBytes(data.getDataBytes()));
    if (messages.length==0) {
      this.addSpammedUri(uri);
    }
    for (int i=0; i<messages.length; i++) {
      messages[i].setSource(uri);
      messages[i].increaseRetrievedCounter();
      MessagePool.instance().addMessage(uri, messages[i]);
    }
  }

  private void addToRequestRetryQueue(String uri) {
    CoreLogger.log("queuing the request "+uri+" for retrying...", CoreLogger.LOG_INFO);
    synchronized (this.requestRetryQueueUris) {
      this.requestRetryQueueUris.add(uri);
    }
  }

  public void requestFailedWithRouteNotFound(String uri) {
    CoreLogger.log("request of "+uri+" failed with route not found", CoreLogger.LOG_WARNING);
    RequestInfo requestInfo = (RequestInfo)this.activeRequestInfos.get(uri);
    requestInfo.retries++;
    requestInfo.routeNotFound++;
    if (requestInfo.retries<=FreenetNetworkSettings.instance().regularRequestRetries) {
      this.addToRequestRetryQueue(uri);
    } else {
      CoreLogger.log("the request failed "+requestInfo.retries+" times. stopped retrying.", CoreLogger.LOG_ERROR);

    }
  }

  public void requestFailedWithDataNotFound(String uri) {
    CoreLogger.log("request of "+uri+" failed with data not found", CoreLogger.LOG_INFO);
    if (this.activeChannelInfos.containsKey(uri)) {
      CoreLogger.log("the request of "+uri+" was a channel request...", CoreLogger.LOG_INFO);
      ChannelInfo channelInfo = (ChannelInfo)(this.activeChannelInfos.get(uri));
      channelInfo.failedToReceiveIndex(this.getIndexFromUri(uri));
      CoreLogger.log("requests on channel "+channelInfo.baseName+" will possibly be continued.", CoreLogger.LOG_INFO);
      synchronized(this.channelsToBeContinued) {
        this.channelsToBeContinued.add(channelInfo);
      }
      this.activeChannelInfos.remove(uri);
      return;
    }
    RequestInfo requestInfo = (RequestInfo)this.activeRequestInfos.get(uri);
    requestInfo.retries++;
    requestInfo.htl+=FreenetNetworkSettings.instance().regularRequestHTLIncrease;
    requestInfo.dataNotFound++;
    if (requestInfo.retries<=FreenetNetworkSettings.instance().regularRequestRetries) {
      this.addToRequestRetryQueue(uri);
    } else {
      CoreLogger.log("the request failed "+requestInfo.retries+" times. stopped retrying.", CoreLogger.LOG_ERROR);
    }
  }


  public void requestStarted(String uri) {
    CoreLogger.log("request for "+uri+" was started... ", CoreLogger.LOG_NORMAL);
    if (this.activeChannelInfos.containsKey(uri)) {
      ChannelInfo info = ChannelInfo.getInstance(uri.substring(0, uri.lastIndexOf('/')+1));
      if (info==null) {
        CoreLogger.log("failed to find the channel "+uri.substring(0, uri.lastIndexOf('/')+1), CoreLogger.LOG_ERROR);
        return;
      }

      info.setStatusString("looking for slot "+info.getCurrentSlot()+" with "+info.getHTLForCurrentRequest()+" htl");
    }
  }

  public void requestFailedBadly(String uri, String info) {
    CoreLogger.log("request of "+uri+" failed way bad: "+info, CoreLogger.LOG_ERROR);
    RequestInfo requestInfo = (RequestInfo)this.activeRequestInfos.get(uri);
    requestInfo.retries++;
    requestInfo.dataNotFound++;
    if (requestInfo.retries<=FreenetNetworkSettings.instance().regularRequestRetries) {
      this.addToRequestRetryQueue(uri);
    } else {
      CoreLogger.log("the request failed "+requestInfo.retries+" times. stopped retrying.", CoreLogger.LOG_ERROR);
    }
  }

  public int getActiveInsertCount() {
    return this.activeInsertMessagesListMap.size();
  }

  public int getSendBufferSize() {
    return this.insertBufferIndex;
  }

  private class RequestInfo {
    int retries=0;
    int routeNotFound=0;
    int dataNotFound=0;
    int htl;

    RequestInfo(int htl) {
      this.htl=htl;
    }
  }
}