package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public abstract class MessageFilter {

  public MessageFilter() {
  }

  private static MessageFilter acceptAllMessageFilter = new MessageFilter() {
    boolean acceptMessage(Message message){
      return true;
    }
  };

  private static MessageFilter otherUsersPostsMessageFilter = new MessageFilter() {
    boolean acceptMessage(Message message) {
      if (message instanceof PostMessage == false) {
        return false;
      }
      if (message.getUniqueId().startsWith(PersonalInfo.instance().getPublicKey())) {
        return false;
      } else {
        return true;
      }
    }
  };



  private static MessageFilter allPostsMessageFilter = new MessageFilter() {
    boolean acceptMessage(Message message) {
      return (message instanceof PostMessage);
    }
  };

  private static MessageFilter chessMessagesOnlyFilter = new MessageFilter() {
    boolean acceptMessage(Message message) {
      boolean is = (message instanceof ChessMessage);
      return (message instanceof ChessMessage);
    }
  };


  private static MessageFilter archiveMessagesFilter = new MessageFilter() {
    boolean acceptMessage(Message message) {
      return (message instanceof ArchiveMessage);
    }
  };

  private static MessageFilter userMessagesAndCommentsOnlyFilter = new MessageFilter() {
    boolean acceptMessage(Message message) {
      return (message instanceof UserMessage || message instanceof UserCommentMessage);
    }
  };

  private static MessageFilter userMessagesOnlyFilter = new MessageFilter() {
    boolean acceptMessage(Message message) {
      return (message instanceof UserMessage);
    }
  };

  private static MessageFilter originalNonArchiveMessagesOnlyFilter = new MessageFilter() {
    boolean acceptMessage(Message message) {
      if (message instanceof ArchiveMessage) return false;
//      return true;
      return (message.getSourceKey().equals(message.getOriginalPublicKey()));
    }
  };

  private static MessageFilter originalMessagesOnlyFilter = new MessageFilter() {
    boolean acceptMessage(Message message) {
      return (message.getSourceKey().equals(message.getOriginalPublicKey()));
    }
  };

  abstract boolean acceptMessage(Message message);

  public static MessageFilter getAcceptAllMessageFilter() {
    return MessageFilter.acceptAllMessageFilter;
  }

  public static MessageFilter getUserMessagesAndCommentsOnlyFilter() {
    return MessageFilter.userMessagesAndCommentsOnlyFilter;
  }

  public static MessageFilter getUserMessagesOnlyFilter() {
    return MessageFilter.userMessagesOnlyFilter;
  }

  public static MessageFilter getAllPostsMessageFilter() {
    return MessageFilter.allPostsMessageFilter;
  }

  public static MessageFilter getArchiveMessagesOnlyFilter() {
    return MessageFilter.archiveMessagesFilter;
  }

  public static MessageFilter originalNonArchiveMessagesOnlyFilter() {
    return MessageFilter.originalNonArchiveMessagesOnlyFilter;
  }

  public static MessageFilter originalMessagesOnlyFilter() {
    return MessageFilter.originalMessagesOnlyFilter;
  }

  public static MessageFilter ignoreByUniqueIDFilter(final java.util.Set setWithIds) {
    return new MessageFilter() {
      public boolean acceptMessage(Message msg) {
        return (setWithIds.contains(msg.getUniqueId())==false);
      }
    };
  }

  public static MessageFilter getMessageTypeFilter(final Class msgClass) {
    return new MessageFilter() {
      public boolean acceptMessage(Message msg) {
        return (msg.getClass().equals(msgClass));
      }

    };
  }

  public static MessageFilter getChessMessagesOnlyFilter() {
    return MessageFilter.chessMessagesOnlyFilter;
  }

  public static MessageFilter getOtherUsersPostsMessageFilter() {
    return MessageFilter.otherUsersPostsMessageFilter;
  }
}