package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class MessageArchiveTransmitter implements freenetmessageboard.fcpinterface.FCPInsertCallback {

  private java.util.Map activeInserts = new java.util.HashMap();

  private static MessageArchiveTransmitter instance;

  private MessageArchiveTransmitter() {

  }

  public synchronized static MessageArchiveTransmitter instance() {
    if (MessageArchiveTransmitter.instance==null) {
      MessageArchiveTransmitter.instance=new MessageArchiveTransmitter();
    }
    return MessageArchiveTransmitter.instance;
  }

  public synchronized void insertArchive(MessageArchive archive, String archiveName) {
    String uri = this.constructArchiveUri(PersonalInfo.instance().getPrivateKey(), archiveName);
    CoreLogger.log("inserting archive to "+uri, CoreLogger.LOG_NORMAL);
    synchronized(this.activeInserts) {
      this.activeInserts.put(uri, archive);
    }
    freenetmessageboard.fcpinterface.FCPFacade.instance().startFreenetInsert(this, uri, new byte[0], archive.getBytes(), FreenetNetworkSettings.instance().archiveInsertHtl, true);
  }

  public static String constructArchiveUri(String publicKey, String archiveName) {
    StringBuffer buf = new StringBuffer(80);
    buf.append("SSK@");
    buf.append(publicKey);
    buf.append("/fmb/archives/");
    buf.append(archiveName);
    buf.append(".zip");
    return buf.toString();
  }

  public void insertSuccesfull(String uri, freenetmessageboard.fcpinterface.InsertInfo insertInfo) {
    CoreLogger.log("the insert of archive to "+PersonalInfo.instance().privateToPublicUri(uri)+" was succesful.", CoreLogger.LOG_NORMAL);
    MessageArchive archive = (MessageArchive)this.activeInserts.get(uri);
    synchronized(this.activeInserts) {
      this.activeInserts.remove(uri);
    }
    ArchiveMessage msg = new ArchiveMessage(PersonalInfo.instance().privateToPublicUri(uri), archive);
    CoreLogger.log("announcing this archive on my personal channel, announcement has "+msg.getString().length()+" chars lenth", CoreLogger.LOG_WARNING);
    MessageGateway.instance().sendMessageOnPersonalChannel(msg);
    freenetmessageboard.Main.getGUI().setInsertArchiveStatusString("insert message archive", true);
  }

  public boolean areThereActiveInserts() {
    return (this.activeInserts.size()>0);
  }

  public void insertFailedWithRouteNotFound(String uri) {
    CoreLogger.log("the insert of archive to "+uri+" failed with route not found, retrying...", CoreLogger.LOG_ERROR);
    MessageArchive archive = (MessageArchive)this.activeInserts.get(uri);
    freenetmessageboard.fcpinterface.FCPFacade.instance().startFreenetInsert(this, uri, new byte[0], archive.getBytes(), FreenetNetworkSettings.instance().archiveInsertHtl, true);
  }

  private String getRandomName() {
    return Double.toString(Math.random()).substring(2);
  }

  public void insertFailedWithKeyCollision(String uri) {
    CoreLogger.log("the insert of archive to "+uri+" failed with key collision.", CoreLogger.LOG_WARNING);
    MessageArchive archive = (MessageArchive)this.activeInserts.get(uri);
    String newUri = this.constructArchiveUri(PersonalInfo.instance().getPrivateKey(), this.getRandomName());
    CoreLogger.log("restarting insert with new uri "+newUri, CoreLogger.LOG_WARNING);
    freenetmessageboard.fcpinterface.FCPFacade.instance().startFreenetInsert(this, newUri, new byte[0], archive.getBytes(), FreenetNetworkSettings.instance().archiveInsertHtl, true);
    synchronized(this.activeInserts) {
      this.activeInserts.remove(uri);
      this.activeInserts.put(newUri, archive);
    }
  }

  public void insertFailedBadly(String uri, String info) {
    CoreLogger.log("the insert of archive to "+uri+" failed: "+info+", retrying...", CoreLogger.LOG_ERROR);
    MessageArchive archive = (MessageArchive)this.activeInserts.get(uri);
    freenetmessageboard.fcpinterface.FCPFacade.instance().startFreenetInsert(this, uri, new byte[0], archive.getBytes(), FreenetNetworkSettings.instance().archiveInsertHtl, true);
  }
}