package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class MessageArchiveReceiver extends javax.swing.table.AbstractTableModel implements Runnable, freenetmessageboard.fcpinterface.FCPRequestCallback, MessageArrivedListener {

  private java.util.List archiveMessagesList = new java.util.LinkedList();

  private java.util.List newArchiveMessagesList = new java.util.LinkedList();

  private java.util.List newMessagesInArchiveCountList = new java.util.LinkedList();
  private java.util.List statusStringList = new java.util.LinkedList();

  private java.util.Set messagesInArchive = new java.util.HashSet();

  private java.util.Map currentRequests = new java.util.HashMap();

  private static MessageArchiveReceiver instance;

  private static String[] colNames = new String[] { "status", "from", "total", "new", "kb", "date","description" };
  private static Class[] colClasses = new Class[] { new String().getClass(), new String().getClass(), new Integer(2).getClass(), new Integer(2).getClass(), new Integer(2).getClass(), new String().getClass(), new String().getClass()};


  private MessageArchiveReceiver() {
    MessagePool.instance().addMessageArrivedListener(this, MessageFilter.getArchiveMessagesOnlyFilter());

  }

  public int getRowCount() {
    int rows;

    CoreLogger.log("entering monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
     synchronized(this.archiveMessagesList) {
      CoreLogger.log("entered monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
      rows=this.archiveMessagesList.size();
      CoreLogger.log("leaving monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
    }
    CoreLogger.log("left monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
    return rows;
  }

  private int countNewMessagesInArchive(ArchiveMessage msg) {
    String[] uniqueIds = msg.getUniqueIDs();
    int newMsgCount=0;
    for (int i=0; i<uniqueIds.length; i++) {
      this.messagesInArchive.add(uniqueIds[i]);
      if (MessagePool.instance().shouldMessageBeIgnored(uniqueIds[i])==false) {
        if (MessagePool.instance().containsMessage(uniqueIds[i])==false) {
          newMsgCount++;
        }
      }
    }
    return newMsgCount;
  }

  public int getColumnCount() {
    return 7;
  }

  public Class getColumnClass(final int col) {
    return MessageArchiveReceiver.colClasses[col];
  }

  public String getColumnName(final int col) {
    return MessageArchiveReceiver.colNames[col];
  }

  public void requestArchive(int i) {
    ArchiveMessage msg = (ArchiveMessage)this.archiveMessagesList.get(i);
    CoreLogger.log("starting request for archive from "+msg.getUri(), CoreLogger.LOG_NORMAL);
    freenetmessageboard.fcpinterface.FCPFacade.instance().startFreenetRequest(this, msg.getUri(), FreenetNetworkSettings.instance().archiveRequestHtl, true);
    synchronized(this.currentRequests) {
      this.currentRequests.put(msg.getUri(), msg);
    }
    this.statusStringList.set(i, "request queued...");
    this.fireTableDataChanged();
  }

  public Object getValueAt(int row, int col) {
    ArchiveMessage msg;
    CoreLogger.log("entering monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
     synchronized(this.archiveMessagesList) {
      CoreLogger.log("entered monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
       msg=(ArchiveMessage)this.archiveMessagesList.get(row);
      CoreLogger.log("leaving monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
    }
    CoreLogger.log("left monitor this.activeMessageList", CoreLogger.LOG_MONITOR);

    if (col==0) {
      return this.statusStringList.get(row);
    }
    if (col==1) {
      return ContactList.instance().getNicknameOfPublicKey(msg.getOriginalPublicKey())+" ("+msg.getOriginalPublicKey()+") ";
    }
    if (col==2) {
      return new Integer(msg.getUniqueIDs().length);
    }
    if (col==3) {
      return this.newMessagesInArchiveCountList.get(row);
    }
    if (col==4) {
      return new Integer(msg.getSize()/1024);
    }
    if (col==5) {
      return msg.getDate();
    }
    if (col==6) {
      return msg.getDescription();
    }

    return "novalue";
  }

  public void run() {
    while(true) {
      try {
        Thread.sleep(3000);
      }
      catch (InterruptedException ex) {
      }
      this.recountNewMsgCounter();
      this.processNewMessages();
      for (int i=0; i<this.archiveMessagesList.size(); i++) {
        this.fireTableCellUpdated(i,3);
      }
    }
  }

  private void recountNewMsgCounter() {
    CoreLogger.log("entering monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
    synchronized(this.archiveMessagesList) {
      CoreLogger.log("entered monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
      for (int i=0; i<this.archiveMessagesList.size(); i++) {
        ArchiveMessage msg = (ArchiveMessage)this.archiveMessagesList.get(i);
        this.newMessagesInArchiveCountList.set(i, new Integer(this.countNewMessagesInArchive(msg)));
      }
      CoreLogger.log("leaving monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
    }
    CoreLogger.log("left monitor this.activeMessageList", CoreLogger.LOG_MONITOR);

  }

  public static synchronized MessageArchiveReceiver instance() {
    if (MessageArchiveReceiver.instance==null) {
      MessageArchiveReceiver.instance=new MessageArchiveReceiver();
    }
    return MessageArchiveReceiver.instance;
  }

  public void start() {
     Thread thread = new Thread(MessageArchiveReceiver.instance);
     thread.setName("MessageArchiveReceiver");
     thread.start();
  }

  public void messageArrived(Message msg) {
    CoreLogger.log("an archive message from "+msg.getOriginalUri()+" has arrived", CoreLogger.LOG_NORMAL);
    CoreLogger.log("entering monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
    synchronized(this.archiveMessagesList) {
      CoreLogger.log("entered monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
      this.newArchiveMessagesList.add(msg);
      CoreLogger.log("leaving monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
    }
    CoreLogger.log("left monitor this.activeMessageList, fireTableDataChanged", CoreLogger.LOG_MONITOR);
  }

  private void processNewMessages() {
    if (this.newArchiveMessagesList.size()==0) return;
    CoreLogger.log("processing new archive messages...", CoreLogger.LOG_NORMAL);
    CoreLogger.log("entering monitor this.newArchiveMessagesList", CoreLogger.LOG_MONITOR);
    synchronized(this.newArchiveMessagesList) {
      CoreLogger.log("entered monitor this.newArchiveMessagesList", CoreLogger.LOG_MONITOR);
      java.util.Iterator it = this.newArchiveMessagesList.iterator();
      while (it.hasNext()) {
        ArchiveMessage msg = (ArchiveMessage)it.next();

        CoreLogger.log("entering monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
        synchronized(this.archiveMessagesList) {
          CoreLogger.log("entered monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
          if (this.archiveMessagesList.contains(msg)==false) {
            this.archiveMessagesList.add(msg);
            this.newMessagesInArchiveCountList.add(new Integer(this.countNewMessagesInArchive((ArchiveMessage)msg)));
            this.statusStringList.add("not receiving");
          }
          CoreLogger.log("leaving monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
        }
        CoreLogger.log("left monitor this.activeMessageList, fireTableDataChanged", CoreLogger.LOG_MONITOR);
        CoreLogger.log("fireRowsInserted", CoreLogger.LOG_MONITOR);
        this.fireTableRowsInserted(this.archiveMessagesList.size()-1, this.archiveMessagesList.size()-1);
      }
      this.newArchiveMessagesList.clear();
      CoreLogger.log("leaving monitor this.newArchiveMessagesList", CoreLogger.LOG_MONITOR);
    }
    CoreLogger.log("left monitor this.newArchiveMessagesList", CoreLogger.LOG_MONITOR);
  }

  public void requestSuccesfull(String uri, freenetmessageboard.fcpinterface.RequestedData data) {
    CoreLogger.log("sucesfull requested archive from "+uri, CoreLogger.LOG_WARNING);
    this.statusStringList.set(this.getIndexOfUri(uri), "succesfull");
    this.fireTableDataChanged();
    MessageArchive archive = new MessageArchive(data.getDataBytes());
    try {
      Message[] messages = archive.getMessages();
      if (messages.length==0) {
        throw new java.io.IOException("no messages in archive");
      }
      for (int i=0; i<messages.length; i++) {
        messages[i].setSource(uri);
        MessagePool.instance().addMessage(uri, messages[i]);
        messages[i].increaseRetrievedCounter();
      }
    } catch (java.io.IOException ex) {
       this.statusStringList.set(this.getIndexOfUri(uri), "no valid archive");
       this.fireTableDataChanged();
    }
    this.currentRequests.remove(uri);
  }

  private int getIndexOfUri(String uri) {
   CoreLogger.log("getting index of archive at uri "+uri, CoreLogger.LOG_MONITOR);
    ArchiveMessage msg = (ArchiveMessage)this.currentRequests.get(uri);
    int index;
    CoreLogger.log("entering monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
     synchronized(this.archiveMessagesList) {
      CoreLogger.log("entered monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
      index= this.archiveMessagesList.indexOf(msg);
      CoreLogger.log("leaving monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
    }
    CoreLogger.log("left monitor this.activeMessageList", CoreLogger.LOG_MONITOR);
    return index;
  }

  public void requestFailedWithRouteNotFound(String uri) {
    CoreLogger.log("archive request for "+uri+" failed with route not found", CoreLogger.LOG_ERROR);
    this.statusStringList.set(this.getIndexOfUri(uri), "route not found");
    this.fireTableDataChanged();
    this.currentRequests.remove(uri);
  }
  public void requestFailedWithDataNotFound(String uri) {
    CoreLogger.log("archive request for "+uri+" failed with data not found", CoreLogger.LOG_NORMAL);
    this.statusStringList.set(this.getIndexOfUri(uri), "data not found");
    this.fireTableDataChanged();
    this.currentRequests.remove(uri);
  }
  public void requestFailedBadly(String uri, String info) {
    CoreLogger.log("archive request for "+uri+" failed: "+info, CoreLogger.LOG_ERROR);
    this.statusStringList.set(this.getIndexOfUri(uri), "failed badly");
    this.fireTableDataChanged();
    this.currentRequests.remove(uri);
  }
  public void requestStarted(String uri) {
    CoreLogger.log("archive request for "+uri+" was started.", CoreLogger.LOG_NORMAL);
    this.statusStringList.set(this.getIndexOfUri(uri), "requesting...");
    this.fireTableDataChanged();
  }
}